% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvstore.R
\name{h2o.download_pojo}
\alias{h2o.download_pojo}
\title{Download the Scoring POJO (Plain Old Java Object) of an H2O Model}
\usage{
h2o.download_pojo(model, path = NULL, getjar = NULL, get_jar = TRUE,
  jar_name = "")
}
\arguments{
\item{model}{An H2OModel}

\item{path}{The path to the directory to store the POJO (no trailing slash). If NULL, then print to
to console. The file name will be a compilable java file name.}

\item{getjar}{(DEPRECATED) Whether to also download the h2o-genmodel.jar file needed to compile the POJO. This argument is now called `get_jar`.}

\item{get_jar}{Whether to also download the h2o-genmodel.jar file needed to compile the POJO}

\item{jar_name}{Custom name of genmodel jar.}
}
\value{
If path is NULL, then pretty print the POJO to the console.
        Otherwise save it to the specified directory and return POJO file name.
}
\description{
Download the Scoring POJO (Plain Old Java Object) of an H2O Model
}
\examples{
\dontrun{
library(h2o)
h <- h2o.init()
fr <- as.h2o(iris)
my_model <- h2o.gbm(x = 1:4, y = 5, training_frame = fr)

h2o.download_pojo(my_model)  # print the model to screen
# h2o.download_pojo(my_model, getwd())  # save the POJO and jar file to the current working
#                                         directory, NOT RUN
# h2o.download_pojo(my_model, getwd(), get_jar = FALSE )  # save only the POJO to the current
#                                                           working directory, NOT RUN
h2o.download_pojo(my_model, getwd())  # save to the current working directory
}
}
