% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guf.R
\name{se}
\alias{se}
\title{Standard Error}
\usage{
se(x, na.rm = TRUE)
}
\arguments{
\item{x}{A vector of numerical values, be it integers and/or real numbers.}

\item{na.rm}{A Boolean, indicating whether NAs need to be removed from x before calculating the Standard Error; defaults to TRUE}
}
\value{
One real number, being the Standard Error.
}
\description{
The Standard Error (`se`) of a numerical vector x.
}
\examples{
my_vector = c(1, 3, 4, 7.5, 8)
var(my_vector); sd(my_vector); se(my_vector)
my_vector = c(NA, 3, 4, 7.5, 8)
var(my_vector); sd(my_vector); se(my_vector)
# note that se() by default leaves out NAs. But compare:
var(my_vector); sd(my_vector); se(my_vector, na.rm=FALSE)
}
