% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{gr_plot_sep}
\alias{gr_plot_sep}
\title{Plot hydrograph separation}
\usage{
gr_plot_sep(
  df,
  years = NULL,
  layout = as.matrix(1),
  pagebreak = FALSE,
  temp = FALSE,
  prec = FALSE,
  span = 5,
  print = TRUE
)
}
\arguments{
\item{df}{\code{data.frame} of hydrograph separation as produced by \code{\link[=gr_separate]{gr_separate()}}.}

\item{years}{Integer vector of years to be plotted.}

\item{layout}{\code{matrix} that encodes the order of plotting.}

\item{pagebreak}{Logical. Whether to break page between plots (used by \code{\link[=gr_report]{gr_report()}}). Defaults to \code{FALSE}.}

\item{temp}{Boolean. Add temperature curve to the plot? Defaults to \code{FALSE}. If both \code{temp = TRUE} and \code{prec = TRUE}, then the axis is drawn for precipitation.}

\item{prec}{Boolean. Add precipitation curve to the plot? Defaults to \code{FALSE}. If both \code{temp = TRUE} and \code{prec = TRUE}, then the axis is drawn for precipitation.}

\item{span}{Integer number of days to accumulate precipitation for plotting.}

\item{print}{Boolean. Print plot? Defaults to \code{TRUE}. Use \code{FALSE} if you want to tweak the plot aesthetics before plotting.}
}
\value{
\code{list} of \code{ggplot2} objects, one for each year, representing the hydrograph separation
}
\description{
The function plots river hydrograph by filling the different flow types using colors. Matrix layouts can be used if multiple plots are needed. Temperature and precipitation can be overlaid.
}
\examples{
library(grwat)

data(spas) # example Spas-Zagorye data is included with grwat package

# separate
sep = gr_separate(spas, params = gr_get_params(reg = 'center'))

# One year
gr_plot_sep(sep, 1978) 

# Two years
gr_plot_sep(sep, c(1978, 1989)) 

# Two years in a matrix layout
gr_plot_sep(sep, 1988:1989, layout = matrix(1:2, nrow = 2, byrow = TRUE)) 

# Add temperature and precipitation
gr_plot_sep(sep, 1991, temp = TRUE, prec = TRUE) 
}
