% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_effect.R
\name{estimate_average_effect}
\alias{estimate_average_effect}
\title{Estimate average treatment effects using a causal forest}
\usage{
estimate_average_effect(forest, target.sample = c("all", "treated",
  "control"), method = c("AIPW", "TMLE"))
}
\arguments{
\item{forest}{The trained forest.}

\item{target.sample}{Which sample to aggregate treatment effects over.}

\item{method}{Method used for doubly robust inference. Can be either
augmented inverse-propensity weighting (AIPW), or
targeted maximum likelihood estimation (TMLE).}
}
\value{
Vector of predictions, along with (optional) variance estimates.
}
\description{
Gets estimates of one of the following
}
\details{
The (conditional) average treatment effect (target.sample = all):
  sum_{i = 1}^n E[Y(1) - Y(0) | X = Xi] / n
The (conditional) average treatment effect on the treated (target.sample = treated):
  sum_{Wi = 1} E[Y(1) - Y(0) | X = Xi] / |{i : Wi = 1}|
The (conditional) average treatment effect on the controls (target.sample = control):
  sum_{Wi = 0} E[Y(1) - Y(0) | X = Xi] / |{i : Wi = 0}|
}
