% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{distribution}
\alias{distribution}
\alias{distribution<-}
\alias{distribution}
\title{define a distribution over data}
\usage{
distribution(greta_array) <- value

distribution(greta_array)
}
\arguments{
\item{greta_array}{a data greta array. For the assignment method it must not
already have a probability distribution assigned}

\item{value}{a greta array with a distribution (see
\code{\link{distributions}})}
}
\description{
\code{distribution} defines probability distributions over
  observed data, e.g. to set a model likelihood.
}
\details{
The extract method returns the greta array if it has a distribution,
  or \code{NULL} if it doesn't. It has no real use-case, but is included for
  completeness
}
\examples{

# define a model likelihood

# observed data and mean parameter to be estimated
# (explicitly coerce data to a greta array so we can refer to it later)
y = as_data(rnorm(5, 0, 3))

mu = uniform(-3, 3)

# define the distribution over y (the model likelihood)
distribution(y) = normal(mu, 1)

# get the distribution over y
distribution(y)

}
