% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{convert_unit}
\alias{convert_unit}
\title{Convert 'GreenFeed' Unit Number}
\usage{
convert_unit(unit)
}
\arguments{
\item{unit}{Number of the 'GreenFeed' unit(s). Can be a numeric, character, list, or vector.}
}
\value{
A character string of the unit(s) in the correct comma-separated format.
}
\description{
Processes the parameter unit to format it correctly as a comma-separated string,
    regardless of whether it is provided as a numeric, character, or list/vector.
}
\examples{
# Example 1: Providing unit as a character vector
unit <- c("592", "593")
convert_unit(unit)

# Example 2: Providing unit as a single numeric
unit <- 592
convert_unit(unit)

# Example 3: Providing unit as a comma-separated character string
unit <- "592, 593"
convert_unit(unit)

# Example 4: Providing unit as a list
unit <- list(592, 593)
convert_unit(unit)

}
\keyword{internal}
