% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnetFlex.R
\name{predict.glmnetfit}
\alias{predict.glmnetfit}
\title{Get predictions from a \code{glmnetfit} fit object}
\usage{
\method{predict}{glmnetfit}(object, newx, s = NULL, type = c("link",
  "response", "coefficients", "nonzero"), exact = FALSE, newoffset, ...)
}
\arguments{
\item{object}{Fitted "glmnetfit" object.}

\item{newx}{Matrix of new values for \code{x} at which predictions are to be
made. Must be a matrix. This argument is not used for \code{type =
c("coefficients","nonzero")}.}

\item{s}{Value(s) of the penalty parameter lambda at which predictions are
required. Default is the entire sequence used to create the model.}

\item{type}{Type of prediction required. Type "link" gives the linear
predictors (eta scale); Type "response" gives the fitted values (mu scale).
Type "coefficients" computes the coefficients at the requested values for s.
Type "nonzero" returns a list of the indices of the nonzero coefficients for
each value of s.}

\item{exact}{This argument is relevant only when predictions are made at values
of \code{s} (lambda) \emph{different} from those used in the fitting of the
original model. If \code{exact=FALSE} (default), then the predict function
uses linear interpolation to make predictions for values of \code{s} (lambda)
that do not coincide with those used in the fitting algorithm. While this is
often a good approximation, it can sometimes be a bit coarse. With
\code{exact=TRUE}, these different values of \code{s} are merged (and sorted)
with \code{object$lambda}, and the model is refit before predictions are made.
In this case, it is required to supply the original data x= and y= as additional
named arguments to predict() or coef(). The workhorse \code{predict.glmnet()}
needs to update the model, and so needs the data used to create it. The same
is true of weights, offset, penalty.factor, lower.limits, upper.limits if
these were used in the original call. Failure to do so will result in an error.}

\item{newoffset}{If an offset is used in the fit, then one must be supplied for
making predictions (except for type="coefficients" or type="nonzero").}

\item{...}{This is the mechanism for passing arguments like \code{x=} when
\code{exact=TRUE}; see \code{exact} argument.}
}
\value{
The object returned depends on type.
}
\description{
Gives fitted values, linear predictors, coefficients and number of non-zero
coefficients from a fitted \code{glmnetfit} object.
}
