% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigGlm.R
\name{bigGlm}
\alias{bigGlm}
\title{fit a glm with all the options in \code{glmnet}}
\usage{
bigGlm(x, ..., path = FALSE)
}
\arguments{
\item{x}{input matrix}

\item{...}{Most other arguments to glmnet that make sense}

\item{path}{Since \code{glmnet} does not do stepsize optimization, the Newton
algorithm can get stuck and not converge, especially with unpenalized fits. With \code{path=TRUE},
the  fit computed with pathwise lasso regularization. The current implementation does this twice:
the first time to get the lambda sequence, and the second time with a zero attached to the end).
Default is \code{path=FALSE}.}
}
\value{
It returns an object of class "bigGlm" that inherits from class
"glmnet". That means it can be predicted from, coefficients extracted via
\code{coef}. It has its own print method.
}
\description{
Fit a generalized linear model as in \code{glmnet} but unpenalized. This
allows all the features of \code{glmnet} such as sparse x, bounds on
coefficients, offsets, and so on.
}
\details{
This is essentially the same as fitting a "glmnet" model with a single value
\code{lambda=0}, but it avoids some edge cases. CAVEAT: If the user tries a
problem with N smaller than or close to p for some models, it is likely to
fail (and maybe not gracefully!) If so, use the \code{path=TRUE} argument.
}
\examples{

# Gaussian
x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
fit1 = bigGlm(x, y)
print(fit1)

fit2=bigGlm(x,y>0,family="binomial")
print(fit2)
fit2p=bigGlm(x,y>0,family="binomial",path=TRUE)
print(fit2p)

}
\seealso{
\code{print}, \code{predict}, and \code{coef} methods.
}
\author{
Trevor Hastie\cr Maintainer: Trevor Hastie
\email{hastie@stanford.edu}
}
\keyword{models}
\keyword{regression}
