% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.glca.R
\name{plot.glca}
\alias{plot.glca}
\title{Plots the Estimated Parameters of Fitted glca Model}
\usage{
\method{plot}{glca}(x, ask = TRUE, ...)
}
\arguments{
\item{x}{an object of "\code{glca}", usually, a result of a call to \code{glca}.}

\item{ask}{a logical value whether to be asked before printing each plot.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
This function plots estimated parameters of model.
}
\description{
\code{plot} method for class "\code{glca}".
}
\examples{
\dontrun{
# LCA
lca = glca(item(DEFECT, HLTH, RAPE, POOR, SINGLE, NOMORE) ~ 1,
            data = gss08, nclass = 3, na.rm = TRUE)
plot(lca)

# Multitple Group LCA (MGLCA)
mglca1 = glca(item(DEFECT, HLTH, RAPE, POOR, SINGLE, NOMORE) ~ 1,
             group = DEGREE, data = gss08, nclass = 3)
plot(mglca1)

# Multitple Group LCA (MGLCA) (measure.inv = FALSE)
mglca2 = glca(item(DEFECT, HLTH, RAPE, POOR, SINGLE, NOMORE) ~ 1,
             group = DEGREE, data = gss08, nclass = 3, measure.inv = FALSE)
plot(mglca2)
plot(mglca2, "all")

# Multilvel LCA (MLCA)
mlca = glca(item(ECIGT, ECIGAR, ESLT, EELCIGT, EHOOKAH) ~ 1,
            group = SCH_ID, data = nyts18, nclass = 3, ncluster = 3)
plot(mlca)
}

}
\seealso{
\code{\link{glca}} \code{\link{gss08}} \code{\link{nyts18}}
}
