% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isValid.R
\name{isValid}
\alias{isValid}
\title{Check validity of g-and-k or g-and-h parameters}
\usage{
isValid(g, k_or_h, c = 0.8, model = c("gk", "gh"), initial_z = seq(-1, 1,
  0.2))
}
\arguments{
\item{g}{Vector of g parameters.}

\item{k_or_h}{Vector of k or h parameters.}

\item{c}{Vector of c parameters.}

\item{model}{Whether to check the g-and-k or g-and-h model.}

\item{initial_z}{Vector of initial z values to use in each optimisation.}
}
\value{
Logical vector denoting whether each parameter combination is valid.
}
\description{
Check whether parameter choices produce a valid g-and-k or g-and-h distribution.
}
\details{
This function tests whether parameter choices provide a valid distribution.
Only g k and c parameters need be supplied as A and B>0 have no effect.
The function operates by numerically minimising the derivative of the quantile function,
and returning \code{TRUE} if the minimum is positive.
It is possible that a local minimum is found, so it is recommended to use multiple optimisation starting points, and to beware that false positive may still result!
}
\examples{
isValid(0:10, -0.5)
isValid(0:10, 0.5, c=0.9, model="gh")
}
\references{
D. Prangle and K. Peel. gk: An R package for the g-and-k and g-and-h distributions, in preparation.
}

