# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Build system dictionary
#'
#' @param dic_dir Directory where the source dictionaries are located.
#' This argument is passed as '-d' option argument.
#' @param out_dir Directory where the binary dictionary will be written.
#' This argument is passed as '-o' option argument.
#' @param encoding Encoding of input csv files.
#' This argument is passed as '-f' option argument.
#' @returns Logical.
#' @name dict_index_sys
#' @keywords internal
NULL

#' Build user dictionary
#'
#' @param dic_dir Directory where the source dictionaries are located.
#' This argument is passed as '-d' option argument.
#' @param file Path to write the user dictionary.
#' This argument is passed as '-u' option argument.
#' @param csv_file Path to an input csv file.
#' @param encoding Encoding of input csv files.
#' This argument is passed as '-f' option argument.
#' @returns Logical.
#' @name dict_index_user
#' @keywords internal
NULL

dict_index_sys <- function(dic_dir, out_dir, encoding) {
    .Call(`_gibasa_dict_index_sys`, dic_dir, out_dir, encoding)
}

dict_index_user <- function(dic_dir, file, csv_file, encoding) {
    .Call(`_gibasa_dict_index_user`, dic_dir, file, csv_file, encoding)
}

#' Get dictionary information
#'
#' @param sys_dic String scalar.
#' @param user_dic String scalar.
#' @returns data.frame.
#'
#' @name dictionary_info
#' @export
NULL

#' Get transition cost between pos attributes
#'
#' @param rcAttr Integer.
#' @param lcAttr Integer.
#' @param sys_dic String.
#' @param user_dic String.
#' @returns Numeric.
#'
#' @name transition_cost
#' @keywords internal
NULL

#' Tokenizer for debug use
#'
#' Tokenizes a character vector
#' and returns all possible results out of the tokenization process.
#' The returned data.frame contains additional attributes for debug usage.
#'
#' @param text String.
#' @param sys_dic String.
#' @param user_dic String.
#' @param partial Logical.
#' @returns data.frame.
#'
#' @name posDebugRcpp
#' @keywords internal
#' @export
NULL

dictionary_info <- function(sys_dic = "", user_dic = "") {
    .Call(`_gibasa_dictionary_info`, sys_dic, user_dic)
}

transition_cost <- function(rcAttr, lcAttr, sys_dic = "", user_dic = "") {
    .Call(`_gibasa_transition_cost`, rcAttr, lcAttr, sys_dic, user_dic)
}

posDebugRcpp <- function(text, sys_dic = "", user_dic = "", partial = 0L) {
    .Call(`_gibasa_posDebugRcpp`, text, sys_dic, user_dic, partial)
}

#' Call tagger inside 'RcppParallel::parallelFor' and return a data.frame.
#'
#' @param text Character vector.
#' @param sys_dic String scalar.
#' @param user_dic String scalar.
#' @param partial Logical.
#' @param grain_size Integer (larger than 1).
#' @returns data.frame.
#'
#' @name posParallelRcpp
#' @keywords internal
#' @export
NULL

posParallelRcpp <- function(text, sys_dic = "", user_dic = "", partial = 0L, grain_size = 1L) {
    .Call(`_gibasa_posParallelRcpp`, text, sys_dic, user_dic, partial, grain_size)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call(`_gibasa_RcppExport_registerCCallable`)
})
