% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-tri-tern.R, R/stat-tri-tern.R
\docType{data}
\name{geom_tri_tern}
\alias{geom_tri_tern}
\alias{stat_tri_tern}
\alias{StatTriTern}
\title{Tribin (ggtern version).}
\usage{
geom_tri_tern(
  mapping = NULL,
  data = NULL,
  stat = "tri_tern",
  position = "identity",
  ...,
  fun = sum,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_tri_tern(
  mapping = NULL,
  data = NULL,
  geom = "tri_tern",
  position = "identity",
  ...,
  bins = 30,
  fun = sum,
  centroid = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{fun}{the scalar function to use for the statistic}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom, stat}{Override the default connection between `geom_hex_tern` and `stat_hex_tern`}

\item{bins}{numeric vector giving number of bins in both vertical and
horizontal directions. Set to 30 by default.}

\item{centroid}{logical to return the centroid of the polygon, rather than the complete polygon}
}
\description{
Divides the plane into regular triangles, counts the number of cases in
each triangles, and then (by default) maps the number of cases to the triangle
fill.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("geom", "hex")}
}

\examples{
set.seed(1)
n  = 1000
df = data.frame(x  = runif(n),
                y  = runif(n),
                z  = runif(n),
                wt = runif(n))
#Equivalent of Hexbin
ggtern(df,aes(x,y,z)) + 
   geom_tri_tern(bins=10,aes(fill=..count..)) + 
   geom_point(size=0.25)

#Custom Function, Mean
ggtern(df,aes(x,y,z)) + 
   geom_tri_tern(bins=5,aes(fill=..stat..,value=wt),fun=mean) + 
   geom_point(size=0.25)
}
\keyword{datasets}
