% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_sector_df.R
\name{sector_df}
\alias{sector_df}
\alias{sector_df_multiple}
\title{sector coordinates}
\usage{
sector_df(
  x = 0.5,
  y = 0.5,
  theta = 25,
  r = 0.5,
  start = 0,
  r_start = 0,
  type = "percent",
  ratio = 1
)

sector_df_multiple(
  x = 0.5,
  y = 0.5,
  theta = 25,
  r = 0.5,
  start = 0,
  r_start = 0,
  type = "percent",
  ratio = 1,
  group
)
}
\arguments{
\item{x}{Numeric, the x-axis coordinate of the sector center.}

\item{y}{Numeric, the y-axis coordinate of the sector center.}

\item{theta}{Numeric, the angle of the sector,
if 'type = "percent"', the input is a percentage(0-100),
if 'type = "degree"', the input is an angle(0-360).}

\item{r}{Numeric, radius of the outer circle of the sector(0-0.5).}

\item{start}{Numeric, starting angle of sector.}

\item{r_start}{Numeric, radius of the inner circle of the sector(0-r).}

\item{type}{"percent", "degree" or an integer (preferably greater than 50),
represents the number of scattered points on the circle where the sector is drawn.
When \code{type = "percent"}, the circumference of the circle where the sector is
located is composed of 100 scattered points;
when \code{type = "degree"}, the circumference of the circle where the sector is
located is composed of 360 scattered points;
when \code{type = 150}, the circumference of the circle where the sector is
located is composed of 150 scattered points.}

\item{ratio}{aspect ratio, expressed as \code{y / x}.}

\item{group}{A numeric vector used to separate locations in x and y into multiple sectors.
If missing, it will be automatically added as a number.}
}
\value{
coordinates of sector.

coordinates of sectors.
}
\description{
According to the input center position, radius and angle,
get the polygon coordinates of a sector.
}
\details{
\code{\link[=sector_df]{sector_df()}} Only one value can be passed in for each parameter,
and a sector coordinate is returned.

\code{\link[=sector_df_multiple]{sector_df_multiple()}} Each parameter can pass in multiple values,
and return multiple sector coordinates

The value of the 'type' parameter is "percent", "degree" or an integer (preferably greater than 50),
represents the number of scattered points on the circle where the sector is drawn.
When type = "percent", the circumference of the circle where the sector is
located is composed of 100 scattered points;
when type = "degree", the circumference of the circle where the sector is
located is composed of 360 scattered points

For more details, please type \code{vignette("ggsector")}.
}
\examples{
## coordinates of single sector
# type of percent, start = 0, r_start = 0
tmp_df <- sector_df(x = 0.5, y = 0.5, theta = 25, r = 0.4, start = 0, r_start = 0)
tmp_df
grid.newpage()
grid.polygon(
    tmp_df$x, tmp_df$y,
    vp = viewport(height = unit(1, "snpc"), width = unit(1, "snpc"))
)
# type of percent, start = 50, r_start = 0.2
tmp_df <- sector_df(x = 0.5, y = 0.5, theta = 25, r = 0.4, start = 50, r_start = 0.2)
tmp_df
grid.newpage()
grid.polygon(
    tmp_df$x, tmp_df$y,
    vp = viewport(height = unit(1, "snpc"), width = unit(1, "snpc"))
)

# type of degree, start = 90, r_start = 0
tmp_df <- sector_df(
    x = 0.5, y = 0.5, theta = 180, r = 0.4,
    start = 90, r_start = 0, type = "degree"
)
tmp_df
grid.newpage()
grid.polygon(
    tmp_df$x, tmp_df$y,
    vp = viewport(height = unit(1, "snpc"), width = unit(1, "snpc"))
)
# type of degree, start = 180, r_start = 0.2
tmp_df <- sector_df(
    x = 0.5, y = 0.5, theta = 180, r = 0.4,
    start = 270, r_start = 0.2, type = "degree"
)
tmp_df
grid.newpage()
grid.polygon(
    tmp_df$x, tmp_df$y,
    vp = viewport(height = unit(1, "snpc"), width = unit(1, "snpc"))
)

## Coordinates of Multiple Sectors
tmp_df <- sector_df_multiple(
    x = c(0.2, 0.5, 0.8),
    theta = c(25, 50, 75),
    r = 0.15,
    start = c(75, 50, 100),
    r_start = c(0, 0.05, 0.1),
    type = "percent"
)
tmp_df
grid.newpage()
grid.polygon(
    tmp_df$x,
    tmp_df$y,
    id = tmp_df$group,
    vp = viewport(height = unit(1, "snpc"), width = unit(1, "snpc")),
    gp = gpar(
        fill = 3:1, col = 1:3
    )
)

# type = 10, 100, 1000
tmp_df <- sector_df_multiple(
    x = c(0.25, 0.5, 0.75),
    theta = c(7.5, 75, 750),
    r = 0.125,
    r_start = c(0.05),
    type = c(c(10, "percent", 1000))
)
tmp_df
grid.newpage()
grid.polygon(
    tmp_df$x,
    tmp_df$y,
    id = tmp_df$group,
    vp = viewport(height = unit(1, "snpc"), width = unit(1, "snpc")),
    gp = gpar(
        fill = 3:1, col = 1:3
    )
)
}
