% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-ma-eq.R
\name{stat_ma_eq}
\alias{stat_ma_eq}
\title{Equation, p-value, R^2 of major axis regression}
\usage{
stat_ma_eq(
  mapping = NULL,
  data = NULL,
  geom = "text_npc",
  position = "identity",
  ...,
  formula = NULL,
  method = "lmodel2:MA",
  method.args = list(),
  n.min = 2L,
  range.y = NULL,
  range.x = NULL,
  nperm = 99,
  eq.with.lhs = TRUE,
  eq.x.rhs = NULL,
  small.r = getOption("ggpmisc.small.r", default = FALSE),
  small.p = getOption("ggpmisc.small.p", default = FALSE),
  coef.digits = 3,
  coef.keep.zeros = TRUE,
  decreasing = getOption("ggpmisc.decreasing.poly.eq", FALSE),
  rr.digits = 2,
  theta.digits = 2,
  p.digits = max(1, ceiling(log10(nperm))),
  label.x = "left",
  label.y = "top",
  hstep = 0,
  vstep = NULL,
  output.type = NULL,
  na.rm = FALSE,
  orientation = NA,
  parse = NULL,
  show.legend = FALSE,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}}. Only needs to be set at the layer level if you
are overriding the plot defaults.}

\item{data}{A layer specific dataset, only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{formula}{a formula object. Using aesthetic names \code{x} and \code{y}
instead of original variable names. Either \code{y ~ x} or \code{x ~ y}.}

\item{method}{function or character If character, "MA", "SMA" , "RMA" or
"OLS", alternatively "lmodel2" or the name of a model fit function are
accepted, possibly followed by the fit function's \code{method} argument
separated by a colon (e.g. \code{"lmodel2:MA"}). If a function different to
\code{lmodel2()}, it must accept arguments named \code{formula},
\code{data}, \code{range.y}, \code{range.x} and \code{nperm} and return a
model fit object of class \code{lmodel2}.}

\item{method.args}{named list with additional arguments.}

\item{n.min}{integer Minimum number of distinct values in the explanatory
variable (on the rhs of formula) for fitting to the attempted.}

\item{range.y, range.x}{character Pass "relative" or "interval" if method
"RMA" is to be computed.}

\item{nperm}{integer Number of permutation used to estimate significance.}

\item{eq.with.lhs}{If \code{character} the string is pasted to the front of
the equation label before parsing or a \code{logical} (see note).}

\item{eq.x.rhs}{\code{character} this string will be used as replacement for
\code{"x"} in the model equation when generating the label before parsing
it.}

\item{small.r, small.p}{logical Flags to switch use of lower case r and p for
coefficient of determination and p-value.}

\item{coef.digits}{integer Number of significant digits to use for
the fitted coefficients.}

\item{coef.keep.zeros}{logical Keep or drop trailing zeros when formatting
the fitted coefficients and F-value.}

\item{decreasing}{logical It specifies the order of the terms in the
returned character string; in increasing (default) or decreasing powers.}

\item{rr.digits, theta.digits, p.digits}{integer Number of digits after the
decimal point to use for R^2, theta and P-value in labels. If \code{Inf},
use exponential notation with three decimal places.}

\item{label.x, label.y}{\code{numeric} with range 0..1 "normalized parent
coordinates" (npc units) or character if using \code{geom_text_npc()} or
\code{geom_label_npc()}. If using \code{geom_text()} or \code{geom_label()}
numeric in native data units. If too short they will be recycled.}

\item{hstep, vstep}{numeric in npc units, the horizontal and vertical step
used between labels for different groups.}

\item{output.type}{character One of "expression", "LaTeX", "text",
"markdown" or "numeric".}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{orientation}{character Either "x" or "y" controlling the default for
\code{formula}.}

\item{parse}{logical Passed to the geom. If \code{TRUE}, the labels will be
parsed into expressions and displayed as described in \code{?plotmath}.
Default is \code{TRUE} if \code{output.type = "expression"} and
\code{FALSE} otherwise.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
A data frame, with a single row and columns as described under
  \strong{Computed variables}. In cases when the number of observations is
  less than \code{n.min} a data frame with no rows or columns is returned
  rendered as an empty/invisible plot layer.
}
\description{
\code{stat_ma_eq} fits model II regressions. From the fitted model it
generates several labels including the equation, p-value,
coefficient of determination (R^2), and number of observations.
}
\details{
This stat can be used to automatically annotate a plot with
  \eqn{R^2}, \eqn{P}-value, \eqn{n} and/or the fitted model equation. It
  supports linear major axis (MA), standard major axis (SMA) and ranged major
  axis (RMA) regression by means of function \code{\link[lmodel2]{lmodel2}}.
  Formulas describing a straight line and including an intercept are the
  only ones currently supported. Please see the documentation, including the
  vignette of package 'lmodel2' for details. The parameters in
  \code{stat_ma_eq()} follow the same naming as in function \code{lmodel2()}.

  It is important to keep in mind that although the fitted line does not
  depend on whether the \eqn{x} or \eqn{y} appears on the rhs of the model
  formula, the numeric estimates for the parameters do depend on this.

  A ggplot statistic receives as \code{data} a data frame that is not the one
  passed as argument by the user, but instead a data frame with the variables
  mapped to aesthetics. \code{stat_ma_eq()} mimics how \code{stat_smooth()}
  works, except that Model II regressions can be fitted. Similarly to
  \code{stat_smooth()} the model is fitted separately to data from each
  group, so the variables mapped to \code{x} and \code{y} should both be
  continuous rather than discrete as well as the corresponding scales.

  The minimum number of observations with distinct values can be set through
  parameter \code{n.min}. The default \code{n.min = 2L} is the smallest
  possible value. However, model fits with very few observations are of
  little interest and using a larger number for \code{n.min} than the default
  is usually wise.
}
\note{
For backward compatibility a logical is accepted as argument for
  \code{eq.with.lhs}. If \code{TRUE}, the default is used, either
  \code{"x"} or \code{"y"}, depending on the argument passed to \code{formula}.
  However, \code{"x"} or \code{"y"} can be substituted by providing a
  suitable replacement character string through \code{eq.x.rhs}.
  Parameter \code{orientation} is redundant as it only affects the default
  for \code{formula} but is included for consistency with
  \code{ggplot2::stat_smooth()}.

  Methods in \code{\link[lmodel2]{lmodel2}} are all computed always except
  for RMA that requires a numeric argument to at least one of \code{range.y}
  or \code{range.x}. The results for specific methods are extracted a
  posteriori from the model fit object. When a function is passed as argument
  to \code{method}, the method can be passed in a list to \code{method.args}
  as member \code{method}. More easily, the name of the function can be
  passed as a character string together with the \code{lmodel2}-supported
  method.

  R option \code{OutDec} is obeyed based on its value at the time the plot
  is rendered, i.e., displayed or printed. Set \code{options(OutDec = ",")}
  for languages like Spanish or French.
}
\section{User-defined methods}{
 User-defined functions can be passed as
  argument to \code{method}. The requirements are 1) that the signature is
  similar to that of function \code{lmodel2()} and 2) that the value returned
  by the function is an object as returned by \code{lmodel2()} or an atomic
  \code{NA} value. Thus, user-defined methods can implement conditional
  skipping of labelling.
}

\section{Aesthetics}{
 \code{stat_ma_eq} understands \code{x} and \code{y}, to
  be referenced in the \code{formula} while the \code{weight} aesthetic is
  ignored. Both \code{x} and \code{y} must be mapped to \code{numeric}
  variables. In addition, the aesthetics understood by the geom
  (\code{"text"} is the default) are understood and grouping respected.

  \emph{Transformation of \code{x} or \code{y} within the model formula
  is not supported by \code{stat_ma_eq()}. In this case, transformations
  should not be applied in the model formula, but instead in the mapping
  of the variables within \code{aes} or in the scales.}
}

\section{Computed variables}{

If \code{output.type} is different from \code{"numeric"} the returned tibble
contains columns listed below. If the fitted model does not contain a given
value, the label is set to \code{character(0L)}.
\describe{
  \item{x,npcx}{x position}
  \item{y,npcy}{y position}
  \item{eq.label}{equation for the fitted polynomial as a character string to be parsed}
  \item{rr.label}{\eqn{R^2} of the fitted model as a character string to be parsed}
  \item{p.value.label}{P-value if available, depends on \code{method}.}
  \item{theta.label}{Angle in degrees between the two OLS lines for lines estimated from \code{y ~ x} and \code{x ~ y} linear model (\code{lm}) fits.}
  \item{n.label}{Number of observations used in the fit.}
  \item{grp.label}{Set according to mapping in \code{aes}.}
  \item{method.label}{Set according \code{method} used.}
  \item{r.squared, theta, p.value, n}{numeric values, from the model fit object}}

If output.type is \code{"numeric"} the returned tibble contains columns
listed below. If the model fit function used does not return a value,
the variable is set to \code{NA_real_}.
\describe{
  \item{x,npcx}{x position}
  \item{y,npcy}{y position}
  \item{coef.ls}{list containing the "coefficients" matrix from the summary of the fit object}
  \item{r.squared, theta, p.value, n}{numeric values, from the model fit object}
  \item{grp.label}{Set according to mapping in \code{aes}.}
  \item{b_0.constant}{TRUE is polynomial is forced through the origin}
  \item{b_i}{One or two columns with the coefficient estimates}}

To explore the computed values returned for a given input we suggest the use
of \code{\link[gginnards]{geom_debug}} as shown in the last examples below.
}

\examples{
# generate artificial data
set.seed(98723)
my.data <- data.frame(x = rnorm(100) + (0:99) / 10 - 5,
                      y = rnorm(100) + (0:99) / 10 - 5,
                      group = c("A", "B"))

# using defaults (major axis regression)
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line() +
  stat_ma_eq()

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line() +
  stat_ma_eq(mapping = use_label("eq"))

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line() +
  stat_ma_eq(mapping = use_label("eq"), decreasing = TRUE)

# use_label() can assemble and map a combined label
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(method = "MA") +
  stat_ma_eq(mapping = use_label("eq", "R2", "P"))

ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(method = "MA") +
  stat_ma_eq(mapping = use_label("R2", "P", "theta", "method"))

# using ranged major axis regression
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(method = "RMA",
               range.y = "interval",
               range.x = "interval") +
  stat_ma_eq(mapping = use_label("eq", "R2", "P"),
             method = "RMA",
             range.y = "interval",
             range.x = "interval")

# No permutation-based test
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(method = "MA") +
  stat_ma_eq(mapping = use_label("eq", "R2"),
             method = "MA",
             nperm = 0)

# explicit formula "x explained by y"
ggplot(my.data, aes(x, y)) +
  geom_point() +
  stat_ma_line(formula = x ~ y) +
  stat_ma_eq(formula = x ~ y,
             mapping = use_label("eq", "R2", "P"))

# modifying both variables within aes()
ggplot(my.data, aes(log(x + 10), log(y + 10))) +
  geom_point() +
  stat_poly_line() +
  stat_poly_eq(mapping = use_label("eq"),
               eq.x.rhs = "~~log(x+10)",
               eq.with.lhs = "log(y+10)~~`=`~~")

# grouping
ggplot(my.data, aes(x, y, color = group)) +
  geom_point() +
  stat_ma_line() +
  stat_ma_eq()

# labelling equations
ggplot(my.data,
       aes(x, y,  shape = group, linetype = group, grp.label = group)) +
  geom_point() +
  stat_ma_line(color = "black") +
  stat_ma_eq(mapping = use_label("grp", "eq", "R2")) +
  theme_classic()

# Inspecting the returned data using geom_debug()
# This provides a quick way of finding out the names of the variables that
# are available for mapping to aesthetics with after_stat().

gginnards.installed <- requireNamespace("gginnards", quietly = TRUE)

if (gginnards.installed)
  library(gginnards)

# default is output.type = "expression"
if (gginnards.installed)
  ggplot(my.data, aes(x, y)) +
    geom_point() +
    stat_ma_eq(geom = "debug")

\dontrun{
if (gginnards.installed)
  ggplot(my.data, aes(x, y)) +
    geom_point() +
    stat_ma_eq(mapping = aes(label = after_stat(eq.label)),
               geom = "debug",
               output.type = "markdown")

if (gginnards.installed)
  ggplot(my.data, aes(x, y)) +
    geom_point() +
    stat_ma_eq(geom = "debug", output.type = "text")

if (gginnards.installed)
  ggplot(my.data, aes(x, y)) +
    geom_point() +
    stat_ma_eq(geom = "debug", output.type = "numeric")
}

}
\seealso{
The major axis regression model is fitted with function
  \code{\link[lmodel2]{lmodel2}}, please consult its documentation. Statistic
  \code{stat_ma_eq()} can return different ready formatted labels depending
  on the argument passed to \code{output.type}. If ordinary least squares
  polynomial regression is desired, then \code{\link{stat_poly_eq}}. If
  quantile-fitted polynomial regression is desired,
  \code{\link{stat_quant_eq}} should be used. For other types of models such
  as non-linear models, statistics \code{\link{stat_fit_glance}} and
  \code{\link{stat_fit_tidy}} should be used and the code for construction of
  character strings from numeric values and their mapping to aesthetic
  \code{label} explicitly supplied in the call.

Other ggplot statistics for major axis regression: 
\code{\link{stat_ma_line}()}
}
\concept{ggplot statistics for major axis regression}
