% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/revgeocode.R
\name{revgeocode}
\alias{revgeocode}
\title{Reverse geocode}
\usage{
revgeocode(location, output = c("address", "more", "all"),
  messaging = FALSE, sensor = FALSE, override_limit = FALSE,
  client = "", signature = "")
}
\arguments{
\item{location}{a location in longitude/latitude format}

\item{output}{amount of output}

\item{messaging}{turn messaging on/off}

\item{sensor}{whether or not the geocoding request comes from a device with a location sensor}

\item{override_limit}{override the current query count (.GoogleGeocodeQueryCount)}

\item{client}{client ID for business users, see https://developers.google.com/maps/documentation/business/webservices/auth}

\item{signature}{signature for business users, see https://developers.google.com/maps/documentation/business/webservices/auth}
}
\value{
depends (at least an address)
}
\description{
reverse geocodes a longitude/latitude location using Google Maps.  Note that in most cases by using this function you are agreeing to the Google Maps API Terms of Service at https://developers.google.com/maps/terms.
}
\details{
note that the google maps api limits to 2500 queries a day.
}
\examples{
\dontrun{ # Server response can be slow; this cuts down check time.

( gc <- as.numeric(geocode('Baylor University')) )
revgeocode(gc)
revgeocode(gc, output = 'more')
revgeocode(gc, output = 'all')
geocodeQueryCheck()

}
}
\author{
David Kahle \email{david.kahle@gmail.com}
}
\seealso{
\url{http://code.google.com/apis/maps/documentation/geocoding/}
}

