% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-ip.R
\name{theme_ip}
\alias{theme_ip}
\alias{theme_ip_light}
\alias{theme_ip_dark}
\title{Themes for IP data}
\usage{
theme_ip_light(base_size = 11, base_family = "")

theme_ip_dark(
  background_color = "black",
  text_color = "white",
  base_size = 11,
  base_family = ""
)
}
\arguments{
\item{base_size}{base font size, given in pts.}

\item{base_family}{base font family}

\item{background_color}{Background color}

\item{text_color}{Text color}
}
\description{
These set sensible defaults for plots generated by ggip.
Use \code{\link[ggplot2:theme]{ggplot2::theme()}} if you want to tweak the results.
}
\examples{
p <- ggplot(data.frame(ip = ip_address("128.0.0.0"))) +
  geom_point(aes(x = ip$x, y = ip$y), color = "grey") +
  coord_ip()

p + theme_ip_light()

p + theme_ip_dark()
}
