% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip_to_cartesian.R
\name{ip_to_cartesian}
\alias{ip_to_cartesian}
\alias{address_to_cartesian}
\alias{network_to_cartesian}
\title{Map IP data to Cartesian coordinates}
\usage{
address_to_cartesian(
  address,
  canvas_network = ip_network("0.0.0.0/0"),
  pixel_prefix = 16,
  curve = c("hilbert", "morton")
)

network_to_cartesian(
  network,
  canvas_network = ip_network("0.0.0.0/0"),
  pixel_prefix = 16,
  curve = c("hilbert", "morton")
)
}
\arguments{
\item{address}{An \code{\link[ipaddress:ip_address]{ip_address}} vector}

\item{canvas_network}{An \code{\link[ipaddress:ip_network]{ip_network}} scalar that
determines the region of IP space visualized by the entire 2D grid. The
default shows the entire IPv4 address space.}

\item{pixel_prefix}{An integer scalar that sets the prefix length of the
network represented by a single pixel. The default value is 16. Increasing
this effectively improves the resolution of the plot.}

\item{curve}{A string to choose the space-filling curve. Choices are
\code{"hilbert"} (default) and \code{"morton"}.}

\item{network}{An \code{\link[ipaddress:ip_network]{ip_network}} vector}
}
\value{
A data.frame containing columns:
\itemize{
\item \code{address_to_cartesian()}: \code{x} and \code{y}
\item \code{network_to_cartesian()}: \code{xmin}, \code{ymin}, \code{xmax} and \code{ymax}
}
}
\description{
These functions are used internally by \code{\link[=coord_ip]{coord_ip()}} to map
\code{\link[ipaddress:ip_address]{ip_address}} and \code{\link[ipaddress:ip_network]{ip_network}}
vectors to Cartesian coordinates. They are exposed externally to support use
of these coordinates outside of ggplot2.
}
\examples{
address_to_cartesian(ip_address("192.168.0.1"))

network_to_cartesian(ip_network("224.0.0.0/4"))
}
