#' Themes for IP data
#'
#' These set sensible defaults for plots generated by ggip.
#' Use [ggplot2::theme()] if you want to tweak the results.
#'
#' @inheritParams ggplot2::theme_grey
#' @param background_color Background color
#' @param text_color Text color
#'
#' @examples
#' p <- ggplot(data.frame(ip = ip_address("128.0.0.0"))) +
#'   geom_point(aes(x = ip$x, y = ip$y), color = "grey") +
#'   coord_ip()
#'
#' p + theme_ip_light()
#'
#' p + theme_ip_dark()
#' @name theme_ip
NULL

#' @rdname theme_ip
#' @importFrom ggplot2 theme %+replace% element_blank element_rect element_text
#' @export
theme_ip_light <- function(base_size = 11, base_family = "") {
  ggplot2::theme_bw(
    base_size = base_size,
    base_family = base_family
  ) %+replace%
    theme(
      axis.text = element_blank(),
      axis.ticks = element_blank(),
      axis.title = element_blank(),
      panel.border = element_blank(),
      panel.grid = element_blank()
    )
}

#' @rdname theme_ip
#' @export
theme_ip_dark <- function(background_color = "black", text_color = "white",
                          base_size = 11, base_family = "") {
  theme_ip_light(
    base_size = base_size,
    base_family = base_family
  ) %+replace%
    theme(
      legend.background = element_rect(fill = background_color),
      legend.key = element_rect(fill = background_color),
      panel.background = element_rect(fill = background_color),
      plot.background = element_rect(fill = background_color)
    ) +
    theme(
      legend.text = element_text(color = text_color),
      legend.title = element_text(color = text_color),
      plot.caption = element_text(color = text_color),
      plot.subtitle = element_text(color = text_color),
      plot.tag = element_text(color = text_color),
      plot.title = element_text(color = text_color)
    )
}
