% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gggenomes.R
\name{layout_genomes}
\alias{layout_genomes}
\title{Layout genomes}
\usage{
layout_genomes(
  seqs = NULL,
  genes = NULL,
  feats = NULL,
  links = NULL,
  infer_bin_id = seq_id,
  infer_start = min(start, end),
  infer_end = max(start, end),
  infer_length = max(start, end),
  adjacent_only = TRUE,
  ...
)
}
\arguments{
\item{seqs}{A data.frame or a character vector with paths to files containing
sequence data. Data columns:
\itemize{
\item required: \verb{seq_id,length}
\item recognized: \verb{bin_id,start,end,strand}
}}

\item{genes, feats}{A data.frame, a list of data.frames, or a character vector
with paths to files containing gene data. Each item is added as feature
track.

For a single data.frame the track_id will be "genes" and "feats",
respectively. For a list, track_ids are parsed from the list names, or if
names are missing from the name of the variable containing each data.frame.
Data columns:
\itemize{
\item required: \verb{seq_id,start,end}
\item recognized: \verb{strand,bin_id,feat_id,introns}
}}

\item{links}{A data.frame or a character vector with paths to files
containing link data. Each item is added as links track. Data columns:
\itemize{
\item required: \verb{seq_id,seq_id2}
\item recognized: \verb{start,end,bin_id,start2,end2,bin_id2,strand}
}}

\item{infer_length, infer_start, infer_end, infer_bin_id}{used to infer pseudo
seqs if only feats or links are provided, or if no bin_id column was
provided. The expressions are evaluated in the context of the first feat
or link track.

By default subregions of sequences from the first to the last feat/link
are generated. Set \code{infer_start} to 0 to show all sequences from their
true beginning.}

\item{adjacent_only}{Indicates whether links should be created between adjacent sequences/chromosomes only.
By default it is set to \code{adjacent_only = TRUE}. If \code{FALSE}, links will be created between all sequences

(\emph{not recommended for large data sets})}

\item{...}{additional parameters, passed to layout}
}
\value{
gggenomes_layout object
}
\description{
Layout genomes
}
\keyword{internal}
