# ggeffects 0.3.4

## General

* Prediction for `glmmTMB`-objects now compute proper confidence intervals, due to fix in package _glmmTMB_ 0.2.1
* If `terms` in `ggpredict()` is missing or `NULL`, marginal effects for each model term are calculated. `ggpredict()` then returns a list of data frames, which can also be plotted with `plot()`.

## Changes to functions

* The `jitter`-argument from `plot()` now accepts a numeric value between 0 and 1, to control the width of the random variation in data points.
* `ggpredict()` and `ggeffect()` can now predict transformed values, which is useful, for instance, to exponentiate predictions for `log(term)` on the original scale of the variable. See package vignette, section _Marginal effects at specific values or levels_ for examples.

## Bug fixes

* Multivariate response models in _brms_ with variable names with underscores and dots were not correctly plotted.

# ggeffects 0.3.3

## General

* Better support for multivariate-response-models from _brms_.
* Support for cumulative-link-models from _brms_.
* `ggpredict()` now supports linear multivariate response models, i.e. `lm()` with multiple outcomes.

## Changes to functions

* `ggpredict()` gets a `pretty`-argument to reduce and "prettify" the value range from variables in `terms` for predictions. This applies to all variables in `terms` with more than 25 unique values.

## Bug fixes

* Recognize negative binomial family from `brmsfit`-models.

# ggeffects 0.3.2

## General

* `ggpredict()`, `ggeffect()` and `gginteraction()` get a `x.as.factor`-argument to preserve factor-class for the `x`-column in the returned data frame.
* The `terms`-argument now also allows the specification of a range of numeric values in square brackets, e.g. `terms = "age [30:50]"`.

## Bug fixes

* Give proper warning that `clm`-models don't support `full.data`-argument.
* `emm()` did not work properly for some random effects models.

# ggeffects 0.3.1

## General

* Use `convert_case()` from *sjlabelled*, in preparation for the latest *snakecase*-package update.

## Bug fixes

* Model weights are now correctly taken into account.

# ggeffects 0.3.0

## General

* Support for `brmsfit`-models from the *brms*-package.
* Support for `clm`-models from the *ordinal*-package.
* Support for `multinom`-models from the *nnet*-package.
* Posterior predictive distributions (see argument `ppd`) now compute uncertainty intervals also for non-gaussian models.
* Use functions from package *sjstats* (link inverse, model frame etc.).
* If the regression model used weights, `ggpredict()` now computes the weighted mean as typical value for predictors that are held constant.
* Use select-helpers from package *tidyselect*, instead of *dplyr*.

## New functions

* New `summary()` function, to provide information on predictions by grouping variables, and on constant values from adjustments.

## Changes to functions

* `plot()` gets a `show.legend`-argument to show or hide the legend of plots.

## Bug fixes

* Fixed issues with `gam`- and `vgam`-models.

# ggeffects 0.2.2

## Changes to functions

* `plot()` gets a `dot.alpha`-argument, to specify a different alpha-values for data points when plotting raw data.
* `plot()` gets a `jitter`-argument, to add a small amount of random variation to the location of data points when plotting raw data.
* `plot()` and getter-functions (like `get_title()` or `get_x_labels()`) get a `case`-argument, to convert labels into any case, using the [snakecase](https://cran.r-project.org/package=snakecase)-package.
* Confidence intervals are now also computed for `hurdle`, `zeroinfl`, `truncreg` and `betareg`-models. Note, however, that due to some uncertainty, the intervals may not be "smooth".

## Bug fixes

* Confidence intervals for generalized mixed effects models are now computed properly.
* Different levels for confidence intervals (argument `ci.lvl`) were not always recognized.
* Fixed issues with `glmmTMB`-models.
* Fixed issues with `lme`-models.
* Fixed issue when plotting data returned from `ggeffect()`, if the term in question was categorical.

# ggeffects 0.2.1

## General

* Support for `stanreg` models (pkg _rstanarm_).
* Fixed issue with latest tidyr-update on CRAN.

## Bug fixes

* Plotting raw data with `plot()` did not work for predictions at specific values (i.e. when certain levels of predictor where selected in square brackets). 
* Computing predictions for `mermod`-objects did not work when model had only one fixed effects term.

# ggeffects 0.2.0

## General

* Updated package imports and dependencies.
* Support for `polr` models (pkg _MASS_).
* Support for `hurdle` and `zeroinfl` models (pkg _pscl_).
* Support for `betareg` models (pkg _betareg_).
* Support for `truncreg` models (pkg _truncreg_).
* Support for `coxph` models (pkg _survival_).

## New functions

* `emm()` as convenient shortcut to compute the estimate marginal mean of the model's response value.

## Changes to functions

* `plot()` gets a `use.theme`-argument, to use the default _ggeffects_-theme, or to use the default _ggplot_-theme.

## Bug fixes

* Fixed issues with columns resp. column names for models that used special functions in formula (e.g. `s()` for `gam`-models, or `bs()` for splines).
* Fixed issue for wrong legend values when grouping term was a non-labelled factor with non-ordered numeric levels.

# ggeffects 0.1.1

## Changes to functions

* `ggpredict()` computes proper confidence intervals for _merMod_- and _lme_-objects.
* Improved `plot()`-method, to better plot raw data.

## Bug fixes

* Confidence intervals were not properly calculated for glm's.
* For `plot()`, argument `rawdata` did not work for models with discrete binary response.
* Fixed issues with models of class `lme` and `glmmTMB`.
* Fixed issues with model-classes that preserved NA-values in model-frame.

# ggeffects 0.1.0

## General

* initial release
