% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_mode.R
\name{light_mode_n}
\alias{light_mode_n}
\title{Light mode theme with no legend}
\usage{
light_mode_n(base_size = 11, base_family = "", x_title = TRUE, y_title = TRUE)
}
\arguments{
\item{base_size}{The base size of the text. Defaults to 11.}

\item{base_family}{The base family of the text. Defaults to "".}

\item{x_title}{TRUE or FALSE whether to have a x axis title. Defaults to TRUE.}

\item{y_title}{TRUE or FALSE whether to have a y axis title. Defaults to TRUE.}
}
\value{
A ggplot theme.
}
\description{
Light mode theme for a ggplot visualisation with no legend. It uses the colours from \code{lightness}.
}
\examples{
library(palmerpenguins)
library(ggplot2)

penguins |>
  gg_jitter(
    x = species,
    y = body_mass_g,
    col = species,
    mode = light_mode_n()
  )

}
