#' @title Freqpoly ggplot
#'
#' @description Create a freqpoly ggplot with a wrapper around [ggplot2::ggplot()] + [geom_freqpoly()][ggplot2::geom_freqpoly()].
#'
#' @inheritParams gg_blanket
#'
#' @return A ggplot object.
#' @export
#'
#' @examples
#'
#' library(ggplot2)
#' library(dplyr)
#' library(palmerpenguins)
#'
#' penguins |>
#'   mutate(across(sex, \(x) stringr::str_to_sentence(x))) |>
#'   gg_freqpoly(
#'     x = flipper_length_mm,
#'     col = sex,
#'     col_title = "",
#'     mode = light_mode_t(),
#'   )
#'
gg_freqpoly <- function(
    data = NULL,
    ...,
    stat = "bin",
    position = "identity",
    coord = ggplot2::coord_cartesian(clip = "off"),
    mode = NULL,
    x = NULL,
    xmin = NULL,
    xmax = NULL,
    xend = NULL,
    y = NULL,
    ymin = NULL,
    ymax = NULL,
    yend = NULL,
    z = NULL,
    col = NULL,
    alpha = NULL,
    facet = NULL,
    facet2 = NULL,
    group = NULL,
    subgroup = NULL,
    label = NULL,
    text = NULL,
    sample = NULL,
    mapping = NULL,
    x_breaks = NULL,
    x_expand = NULL,
    x_expand_limits = NULL,
    x_labels = NULL,
    x_limits = NULL,
    x_oob = scales::oob_keep,
    x_position = "bottom",
    x_title = NULL,
    x_transform = NULL,
    y_breaks = NULL,
    y_expand = NULL,
    y_expand_limits = NULL,
    y_labels = NULL,
    y_limits = NULL,
    y_oob = scales::oob_keep,
    y_position = "left",
    y_title = NULL,
    y_transform = NULL,
    col_breaks = NULL,
    col_expand_limits = NULL,
    col_labels = NULL,
    col_legend_ncol = NULL,
    col_legend_nrow = NULL,
    col_legend_rev = FALSE,
    col_limits = NULL,
    col_oob = scales::oob_keep,
    col_pal = NULL,
    col_pal_na = "darkgrey",
    col_rescale = scales::rescale(),
    col_steps = FALSE,
    col_title = NULL,
    col_transform = NULL,
    alpha_breaks = NULL,
    alpha_expand_limits = NULL,
    alpha_labels = NULL,
    alpha_legend_ncol = NULL,
    alpha_legend_nrow = NULL,
    alpha_legend_rev = FALSE,
    alpha_limits = NULL,
    alpha_oob = scales::oob_keep,
    alpha_pal = NULL,
    alpha_pal_na = NA,
    alpha_title = NULL,
    alpha_transform = NULL,
    facet_axes = NULL,
    facet_axis_labels = "margins",
    facet_labels = NULL,
    facet_labels_position = "top",
    facet_labels_switch = NULL,
    facet_layout = NULL,
    facet_ncol = NULL,
    facet_nrow = NULL,
    facet_scales = "fixed",
    facet_space = "fixed",
    title = NULL,
    subtitle = NULL,
    caption = NULL,
    titles_to_case = snakecase::to_sentence_case
) {

  gg_blanket(
    data = data,
    geom = "line",
    stat = stat,
    position = position,
    coord = coord,
    mode = mode,
    x = {{ x }},
    y = {{ y }},
    xmin = {{ xmin }},
    xmax = {{ xmax }},
    xend = {{ xend }},
    ymin = {{ ymin }},
    ymax = {{ ymax }},
    yend = {{ yend }},
    z = {{ z }},
    col = {{ col }},
    alpha = {{ alpha }},
    facet = {{ facet }},
    facet2 = {{ facet2 }},
    group = {{ group }},
    subgroup = {{ subgroup }},
    label = {{ label }},
    text = {{ text }},
    sample = {{ sample }},
    mapping = mapping,
    x_breaks = x_breaks,
    x_expand = x_expand,
    x_expand_limits = x_expand_limits,
    x_labels = x_labels,
    x_limits = x_limits,
    x_oob = x_oob,
    x_position = x_position,
    x_title = x_title,
    x_transform = x_transform,
    y_breaks = y_breaks,
    y_expand = y_expand,
    y_expand_limits = y_expand_limits,
    y_labels = y_labels,
    y_limits = y_limits,
    y_oob = y_oob,
    y_position = y_position,
    y_title = y_title,
    y_transform = y_transform,
    col_breaks = col_breaks,
    col_expand_limits = col_expand_limits,
    col_labels = col_labels,
    col_legend_ncol = col_legend_ncol,
    col_legend_nrow = col_legend_nrow,
    col_legend_rev = col_legend_rev,
    col_limits = col_limits,
    col_oob = col_oob,
    col_pal = col_pal,
    col_pal_na = col_pal_na,
    col_rescale = col_rescale,
    col_steps = col_steps,
    col_title = col_title,
    col_transform = col_transform,
    alpha_breaks = alpha_breaks,
    alpha_expand_limits = alpha_expand_limits,
    alpha_labels = alpha_labels,
    alpha_legend_ncol = alpha_legend_ncol,
    alpha_legend_nrow = alpha_legend_nrow,
    alpha_legend_rev = alpha_legend_rev,
    alpha_limits = alpha_limits,
    alpha_oob = alpha_oob,
    alpha_pal = alpha_pal,
    alpha_pal_na = alpha_pal_na,
    alpha_title = alpha_title,
    alpha_transform = alpha_transform,
    facet_axes = facet_axes,
    facet_axis_labels = facet_axis_labels,
    facet_labels = facet_labels,
    facet_labels_position = facet_labels_position,
    facet_labels_switch = facet_labels_switch,
    facet_layout = facet_layout,
    facet_ncol = facet_ncol,
    facet_nrow = facet_nrow,
    facet_scales = facet_scales,
    facet_space = facet_space,
    title = title,
    subtitle = subtitle,
    caption = caption,
    titles_to_case = titles_to_case,
    ...
  )
}
