% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-quasirandom.R
\name{position_quasirandom}
\alias{position_quasirandom}
\title{Violin point-style plots to show overlapping points. x must be discrete.}
\usage{
position_quasirandom(width = NULL, varwidth = FALSE, bandwidth = 0.5,
  nbins = NULL, method = "quasirandom", groupOnX = NULL,
  dodge.width = 0)
}
\arguments{
\item{width}{the maximum amount of spread (default: 0.4)}

\item{varwidth}{vary the width by the relative size of each group}

\item{bandwidth}{the bandwidth adjustment to use when calculating density
Smaller numbers (< 1) produce a tighter "fit". (default: 0.5)}

\item{nbins}{the number of bins used when calculating density (has little effect with quasirandom/random distribution)}

\item{method}{the method used for distributing points (quasirandom, pseudorandom, smiley or frowney)}

\item{groupOnX}{if TRUE then jitter is added to the x axis and if FALSE jitter is added to the y axis. Prior to v0.6.0, the default NULL causes the function to guess which axis is the categorical one based on the number of unique entries in each. This could result in unexpected results when the x variable has few unique values and so in v0.6.0 the default was changed to always jitter on the x axis unless groupOnX=FALSE. Also consider \code{\link[ggplot2]{coord_flip}}.}

\item{dodge.width}{Amount by which points from different aesthetic groups will be dodged. This requires that one of the aesthetics is a factor.}
}
\description{
Violin point-style plots to show overlapping points. x must be discrete.
}
\examples{

  ggplot2::qplot(class, hwy, data = ggplot2::mpg, position=position_quasirandom())

}
\seealso{
\code{\link[vipor]{offsetX}}

Other position adjustments: \code{\link{position_beeswarm}}
}
