% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gfilmm.R
\name{gfilmm}
\alias{gfilmm}
\alias{print.gfilmm}
\title{Generalized fiducial inference}
\usage{
gfilmm(
  y,
  fixed,
  random,
  data,
  N,
  thresh = N/2,
  precision = "double",
  seed = NULL
)

\method{print}{gfilmm}(x, ...)
}
\arguments{
\item{y}{a right-sided formula of the form \code{~ cbind(lower,upper)} for 
the interval data}

\item{fixed}{a right-sided formula for the fixed effects}

\item{random}{a right-sided formula for the random effects, or \code{NULL} 
for no random effect}

\item{data}{the data, a dataframe}

\item{N}{desired number of simulations}

\item{thresh}{threshold, default \code{N/2}; for experts only}

\item{precision}{one of \code{"double"}, \code{"long"}, or 
\code{"quadruple"}, the precision used in the algorithm}

\item{seed}{the seed for the C++ random numbers generator, a positive 
integer, or \code{NULL} to use a random seed}

\item{x}{a \code{gfilmm} object}

\item{...}{ignored}
}
\value{
A list with two components: a dataframe \code{VERTEX}, and a vector 
  \code{WEIGHT}. It has class \code{gfilmm}.
}
\description{
Samples the fiducial distributions.
}
\examples{
h <- 0.01
gfi <- gfilmm(~ cbind(yield-h, yield+h), ~ 1, ~ block, data = npk, N=5000)
# fiducial cumulative distribution function of the intercept:
Fintercept <- gfiCDF(~ `(Intercept)`, gfi)
plot(Fintercept, xlim = c(40, 65))
# fiducial confidence interval of the intercept:
gfiConfInt(~ `(Intercept)`, gfi)
# fiducial density function of the intercept:
library(kde1d)
kfit <- kde1d(gfi$VERTEX[["(Intercept)"]], weights = gfi$WEIGHT)
curve(dkde1d(x, kfit), from = 45, to = 65)
}
\references{
J. Cisewski and J.Hannig. 
  \emph{Generalized fiducial inference for normal linear mixed models}. 
  The Annals of Statistics 2012, Vol. 40, No. 4, 2102–2127.
}
