% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bearingarea.R
\name{svk}
\alias{svk}
\title{Reduced Valley Depth}
\usage{
svk(x)
}
\arguments{
\item{x}{A raster or matrix.}
}
\value{
A numeric value representing the reduced valley depth.
}
\description{
Determines the reduced valley depth (Svk), the
height difference between y value of the lowest
intersection point of the least mean square line
fit to the flattest 40\% of the bearing area curve and
the minimum y value of the bearing area curve.
See Figure 2a from Kedron et al. (2018) for more details.
}
\examples{
# import raster image
data(normforest)

# determine the reduced valley depth
Svk <- svk(normforest)
}
