% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse.r
\name{collapse}
\alias{collapse}
\title{collapses a data set by variables using arbitrary aggregation functions}
\usage{
collapse(values, byvar = NULL)
}
\arguments{
\item{values}{an argument with the form \code{"fun1(var1) fun2(var2) fun3(var3,var4)"} describe the aggregations to be performed where fun1, fun2, fun3 are most likely aggregation functions like "sum", "mean", "max", "median", etc. But the function could be anything that returns a scalar.}

\item{byvar}{a variable list giving the variables to collapse by.  The resulting dataset will have as many rows as there are unique levels of the \code{byvar} variable list.}
}
\value{
returns NULL, invisibly
}
\description{
collapse a data set to produce summary statistics possibly by a set of variables as in the Stata code: collapse (fun1) var1 (fun2) var2, by(byvar1 byvar2).  But this function is more flexible than the Stata version because any arbitrary function can be used in collapse not just traditional aggregation functions.
}
\examples{
library(plm)
data(Produc)
use(Produc, clear=TRUE)
listif()
collapse("sum(emp)","year")
listif()
}
