% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decileVote.R
\name{decileVote}
\alias{decileVote}
\title{Function compares nine deciles of a matrix to reference minimum (eg p stock returns)}
\usage{
decileVote(mtx, howManySd = 0.1)
}
\arguments{
\item{mtx}{{ (n X p) matrix of data. For example, returns on p stocks n months}}

\item{howManySd}{{used to define fixmin= imaginary lowest return defined by going
 howManySd=default=0.1 maximum standard deviations of all stockss below 
the minimum return for all stocks in the data}}
}
\value{
out is a matrix with p columns (same as in the input matrix x) and
twenty rows. Top nine rows have deciels quantities, next nine are their ranks.
The 19-th row of out has weighted sum of ranks. All compared to the minimum rank
portfolio manager can give largest weight to the column with smalles bottom line.
The bottom line (20-th) labelled choice of output matrix suggests 
portfolio manager give the highest weight to the investment option in
the column having number 1 and the lowest weight (=0?) to the column 
having number p as the choice number. 
Another output of the function is fixmin calculated in this function.
}
\description{
The first step computes a minimum reference return and  nine deciles.
The input x must be a matrix having p columns (col.names recommended).
and n rows as in the data.  If data are missing for some columns, insert NA's.
Thus x has p column of data matrix ready for comparison and ranking. 
For example, x has a matrix of stock returns.
The output matrix produced by this function also has p columns for each 
column (i.e. for each stock being compared). The output matrix has
nineteen rows. Top nine rows have the magnitudes of deciles.
rows 10 to 18 have respective ranks of the decile magnitudes. 
The output final row  reports a weighted sum
of ranks.  Ranking always gives the smallest number 1 to the most desirable outcome.  
The 19th line of the
output matrix has weighted sum of ranks and we suggest higher portfolio weight
be given to the column having smallest value (in the 19th line)
or chooing in the order of numbers in the last (20th) line of out matrix.
}
\examples{
x1=c(1,4,7,2,6)
x2=c(3,4,8,4,7)
decileVote(cbind(x1,x2))

}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
