### Sub-option 6: isolation by distance between groups

This option is analogous to the previous one, but derives $D\sigma^2$ estimates from a regression of
$F_{\mathrm{ST}}$/(1-$F_{\mathrm{ST}}$)* estimates\index{Dsigma2@$D\sigma^2$ estimation!Fst@$\Fst/(1-\Fst)$ statistic} to geographic distance in a linear habitat, or log(distance) in a two-dimensional habitat [@Rousset97].

Both diploid and haploid data (through `EstimationPloidy=Haploid`) are handled. Missing information is handled as in option 6.5. Input format is the same, except that some samples must contain several individuals. The coordinates of each sample are still contained in the name of each sample, that is in the name of the last individual in each sample.

In addition some allele-size based analyses are possible (by the setting `AllelicDistance=Size`) but again they are not advised in general. Further options within option 6.6 are: `isolationStatistic`; `SingleGeneDiv`; minimal geographic distance; log transformation for geographic distances; testing a given value of the slope; Mantel test settings; conversion to genetic distance matrix in Phylip format. They operate as described above for analyses between individuals, the only difference being the genetic distance used (see Table \@ref(tab:isolstats)). In particular, a minor variant of the $F/(1-F)$ estimator is introduced in version 4.1, by analogy to the “between individuals” estimators. Recall that $F/(1-F)=(Q_r-Q_0)/(1-Q_0)$ where $1-Q_0$ is the within-deme gene diversity. The $F/(1-F)$ method uses per-pair estimates of this within-deme gene diversity, which may not be best. With `IsolationStatistic=SingleGeneDiv` a single estimate is used for all pairwise statistics. In principe this should be better when small per-group samples are considered, but the generic $F/(1-F)$ method is still available as the default method. Limited testing so far suggests little effect of the choice of the statistic on inferences from samples with 10 haploid individuals per group and high overall diversity.

Output is written in three files *yourdata*`.ISO`, *yourdata*`.MIG`, and *yourdata*`.GRA` with the same contents as in option 6.5, except for the nature of the genetic distances.
