/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.yadas;

import edu.uci.ics.jung.graph.util.Pair;
import gov.lanl.yadas.ArgumentMaker;
import java.util.Arrays;
import java.util.List;
import org.drugis.mtc.model.Treatment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThetaArgumentMaker
implements ArgumentMaker {
    private final List<Treatment> d_treatments;
    private final List<List<Pair<Treatment>>> d_studyPmtz;
    private final int d_muIdx;
    private final int d_deltaIdx;
    private int[] d_parent;
    private int[] d_treatmentDeltaIndex;

    public ThetaArgumentMaker(List<Treatment> treatments, List<List<Pair<Treatment>>> studyPmtz, int muIdx, int deltaIdx) {
        this.d_treatments = treatments;
        this.d_studyPmtz = studyPmtz;
        this.d_muIdx = muIdx;
        this.d_deltaIdx = deltaIdx;
        this.d_parent = new int[this.d_treatments.size()];
        Arrays.fill(this.d_parent, -1);
        this.d_treatmentDeltaIndex = new int[this.d_treatments.size()];
        Arrays.fill(this.d_treatmentDeltaIndex, -1);
        int dIdx = 0;
        int i = 0;
        while (i < this.d_studyPmtz.size()) {
            for (Pair<Treatment> pair : this.d_studyPmtz.get(i)) {
                int bIdx = this.d_treatments.indexOf(pair.getFirst());
                int tIdx = this.d_treatments.indexOf(pair.getSecond());
                this.d_parent[tIdx] = bIdx;
                this.d_treatmentDeltaIndex[tIdx] = dIdx++;
            }
            ++i;
        }
        int cnt = 0;
        int i2 = 0;
        while (i2 < this.d_parent.length) {
            if (this.d_parent[i2] == -1) {
                ++cnt;
            }
            ++i2;
        }
        if (cnt != 1) {
            throw new IllegalArgumentException("The studyParameterization should have a tree structure.");
        }
    }

    @Override
    public double[] getArgument(double[][] data) {
        double[] rval = new double[this.d_treatments.size()];
        int i = 0;
        while (i < rval.length) {
            rval[i] = this.theta(i, data);
            ++i;
        }
        return rval;
    }

    protected double theta(int tIdx, double[][] data) {
        double delta = 0.0;
        while (this.d_parent[tIdx] != -1) {
            int dIdx = this.d_treatmentDeltaIndex[tIdx];
            delta += data[this.d_deltaIdx][dIdx];
            tIdx = this.d_parent[tIdx];
        }
        return data[this.d_muIdx][0] + delta;
    }
}

