/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.drugis.mtc.MCMCResults;

public class MCMCResultsWriter {
    private MCMCResults d_results;

    public MCMCResultsWriter(MCMCResults r) {
        this.d_results = r;
    }

    public void write(OutputStream o) throws IOException {
        this.write(new OutputStreamWriter(o));
    }

    public void write(Writer w) throws IOException {
        BufferedWriter out = new BufferedWriter(w);
        out.write("`trace` <-\n");
        out.write("structure(list(");
        String paramstr = "";
        int p = 0;
        while (p < this.d_results.getParameters().length) {
            String namestr = "\"" + this.d_results.getParameters()[p].getName() + "\"";
            paramstr = String.valueOf(paramstr) + namestr + ", ";
            out.write(String.valueOf(namestr) + " = structure(c(");
            int i = 0;
            while (i < this.d_results.getNumberOfChains()) {
                int j = 0;
                while (j < this.d_results.getNumberOfSamples()) {
                    Double d = this.d_results.getSample(p, i, j);
                    out.write(d.toString());
                    if (j != this.d_results.getNumberOfSamples() - 1 || i != this.d_results.getNumberOfChains() - 1) {
                        out.write(",");
                    }
                    ++j;
                }
                ++i;
            }
            out.write("), .Dim = structure(c(1L," + this.d_results.getNumberOfSamples() + "L," + this.d_results.getNumberOfChains() + "L), ");
            out.write(".Names = c(\"\",\"iteration\",\"chain\")))");
            if (p < this.d_results.getParameters().length - 1) {
                out.write(", \n");
            }
            ++p;
        }
        paramstr = paramstr.substring(0, paramstr.length() - 2);
        out.write("), \n.Names = c(" + paramstr + "))\n");
        out.flush();
    }
}

