/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.iterators;

import java.util.ListIterator;
import org.apache.commons.collections15.Unmodifiable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableListIterator<E>
implements ListIterator<E>,
Unmodifiable {
    private ListIterator<E> iterator;

    public static <E> ListIterator<E> decorate(ListIterator<E> iterator) {
        if (iterator == null) {
            throw new IllegalArgumentException("ListIterator must not be null");
        }
        if (iterator instanceof Unmodifiable) {
            return iterator;
        }
        return new UnmodifiableListIterator<E>(iterator);
    }

    private UnmodifiableListIterator(ListIterator<E> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        return this.iterator.next();
    }

    @Override
    public int nextIndex() {
        return this.iterator.nextIndex();
    }

    @Override
    public boolean hasPrevious() {
        return this.iterator.hasPrevious();
    }

    @Override
    public E previous() {
        return this.iterator.previous();
    }

    @Override
    public int previousIndex() {
        return this.iterator.previousIndex();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported");
    }

    @Override
    public void set(E obj) {
        throw new UnsupportedOperationException("set() is not supported");
    }

    @Override
    public void add(E obj) {
        throw new UnsupportedOperationException("add() is not supported");
    }
}

