/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.JumpPerturber;
import java.text.NumberFormat;
import java.util.Random;

public class SingleLogPerturber
implements JumpPerturber {
    private String stringvalue = "";
    private NumberFormat nf;
    private final int which;
    private final int whichpoint;
    private double mss;
    private double scale = 1.0;
    static Random rand = new Random(System.currentTimeMillis());

    public SingleLogPerturber(int which, int whichpoint, double mss) {
        this.which = which;
        this.whichpoint = whichpoint;
        this.mss = mss;
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(3);
        this.nf.setGroupingUsed(false);
    }

    public void perturb(double[][] candarray, int whoseTurn) {
        whoseTurn = this.whichpoint;
        this.scale = Math.exp(this.mss * rand.nextGaussian());
        double[] dArray = candarray[this.which];
        int n = whoseTurn;
        dArray[n] = dArray[n] * this.scale;
        this.stringvalue = this.nf.format(candarray[this.which][whoseTurn]) + "";
    }

    public int numTurns() {
        return 1;
    }

    public double jacobian() {
        return this.scale;
    }

    public double density(double[][] oldarr, double[][] newarr, int whoseTurn) {
        whoseTurn = this.whichpoint;
        double ratio = newarr[this.which][this.whichpoint] / oldarr[this.which][this.whichpoint];
        return 1.0 / Math.sqrt(Math.PI * 2) / this.mss * Math.exp(-Math.log(ratio) * Math.log(ratio) / 2.0 / this.mss / this.mss) / newarr[this.which][whoseTurn];
    }

    public String toString() {
        return this.stringvalue;
    }
}

