/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.MCMCBond;
import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.Tools;

public class PermutationParameter
extends MCMCParameter {
    private int n;
    double[] candidate;

    public PermutationParameter(double[] init, int n, String name) {
        super(new double[n], Tools.rep(1.0, n), name);
        this.n = n;
        this.value = new double[n];
        for (int i = 0; i < n; ++i) {
            this.value[i] = init[i];
        }
    }

    public PermutationParameter(int n, String name) {
        super(new double[n], Tools.rep(1.0, n), name);
        this.n = n;
        this.value = new double[n];
        for (int i = 0; i < n; ++i) {
            this.value[i] = i;
        }
    }

    public void update() {
        if (this.isConstant) {
            return;
        }
        while (this.whoseTurn < this.value.length) {
            this.candidate = this.candidate();
            double ap = this.acceptanceProbability();
            if (ap > (double)MCMCParameter.rand.nextFloat()) {
                this.takeStep();
            }
            ++this.whoseTurn;
        }
        this.whoseTurn = 0;
    }

    public double[] candidate() {
        int trade = (int)((double)this.n * MCMCParameter.rand.nextDouble());
        double[] temp = new double[this.n];
        System.arraycopy(this.value, 0, temp, 0, this.n);
        temp[this.whoseTurn] = this.value[trade];
        temp[trade] = this.value[this.whoseTurn];
        return temp;
    }

    public double acceptanceProbability() {
        double lr = 0.0;
        MCMCBond[] baunds = this.relevantBonds();
        for (int j = 0; j < baunds.length; ++j) {
            lr += baunds[j].compute(this.whatami[j], this.candidate);
        }
        return Math.exp(lr);
    }

    public void takeStep() {
        System.arraycopy(this.candidate, 0, this.value, 0, this.n);
    }
}

