/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.MCMCBond;
import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.MCMCUpdate;
import gov.lanl.yadas.Perturber;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class MultipleParameterUpdate
implements MCMCUpdate {
    MCMCParameter[] params;
    Perturber perturber;
    private int whoseTurn = 0;
    private int numTurns;
    int n;
    int[] len;
    double[][] candarray;
    MCMCBond[] bonds;
    private int[] num;
    private int[][] whatami;
    static Random rand = new Random(System.currentTimeMillis());
    int[] accs;
    static boolean warned = false;

    public MultipleParameterUpdate(MCMCParameter[] params, Perturber perturber) {
        int i;
        if (!warned) {
            System.out.println("Be sure to double check that you are not trying to update \nany constant parameters.  MultipleParameterUpdate will let you do it.");
            warned = true;
        }
        this.params = params;
        this.perturber = perturber;
        this.numTurns = perturber.numTurns();
        this.accs = new int[this.numTurns];
        for (i = 0; i < this.numTurns; ++i) {
            this.accs[i] = 0;
        }
        this.n = params.length;
        this.candarray = new double[this.n][];
        this.len = new int[this.n];
        for (i = 0; i < this.n; ++i) {
            this.len[i] = params[i].length();
            this.candarray[i] = new double[this.len[i]];
        }
        HashSet<MCMCBond> bondset = new HashSet<MCMCBond>();
        for (int ii = 0; ii < this.n; ++ii) {
            MCMCBond[] b1 = params[ii].relevantBonds();
            for (int i2 = 0; i2 < b1.length; ++i2) {
                bondset.add(b1[i2]);
            }
        }
        MCMCBond[] b = new MCMCBond[bondset.size()];
        int jj = 0;
        Iterator x = bondset.iterator();
        while (x.hasNext()) {
            b[jj++] = (MCMCBond)x.next();
        }
        this.bonds = b;
        this.whatami = new int[this.bonds.length][];
        this.num = new int[this.bonds.length];
        for (int j = 0; j < this.bonds.length; ++j) {
            this.num[j] = 0;
            this.whatami[j] = new int[this.n];
            ArrayList al = b[j].getParamList();
            for (int i3 = 0; i3 < this.n; ++i3) {
                boolean contains1 = al.contains(params[i3]);
                if (contains1) {
                    this.whatami[j][i3] = al.indexOf(params[i3]);
                    int n = j;
                    this.num[n] = this.num[n] + 1;
                    continue;
                }
                this.whatami[j][i3] = -1;
            }
        }
    }

    public void update() {
        while (this.whoseTurn < this.numTurns) {
            double candidate = this.candidate()[0];
            double ap = this.acceptanceProbability();
            if (ap > (double)rand.nextFloat()) {
                this.takeStep();
            }
            ++this.whoseTurn;
        }
        this.whoseTurn = 0;
    }

    public double[] candidate() {
        for (int i = 0; i < this.params.length; ++i) {
            System.arraycopy(this.params[i].value, 0, this.candarray[i], 0, this.len[i]);
        }
        this.perturber.perturb(this.candarray, this.whoseTurn);
        return new double[]{0.0};
    }

    public MCMCBond[] relevantBonds() {
        return this.bonds;
    }

    public double acceptanceProbability() {
        double lr = 0.0;
        for (int j = 0; j < this.bonds.length; ++j) {
            int[] temp = this.whatami[j];
            int[] whatamivec = new int[this.num[j]];
            int[] whichvec = new int[this.num[j]];
            int k = 0;
            for (int i = 0; i < this.whatami[j].length; ++i) {
                if (this.whatami[j][i] < 0) continue;
                whichvec[k] = i;
                whatamivec[k] = this.whatami[j][i];
                ++k;
            }
            lr += this.bonds[j].compute(whatamivec, this.candarray, whichvec);
        }
        return this.perturber.jacobian() * Math.exp(lr);
    }

    public void takeStep() {
        for (int i = 0; i < this.n; ++i) {
            this.params[i].setValue(this.candarray[i]);
        }
        for (int j = 0; j < this.bonds.length; ++j) {
            this.bonds[j].revise();
        }
        int n = this.whoseTurn;
        this.accs[n] = this.accs[n] + 1;
    }

    public void ignoreBond(MCMCBond ignorable) {
        HashSet<MCMCBond> bondset = new HashSet<MCMCBond>();
        for (int j = 0; j < this.bonds.length; ++j) {
            bondset.add(this.bonds[j]);
        }
        boolean removed = bondset.remove(ignorable);
        if (!removed) {
            return;
        }
        this.bonds = new MCMCBond[bondset.size()];
        int k = 0;
        Iterator iter = bondset.iterator();
        while (iter.hasNext()) {
            this.bonds[k++] = (MCMCBond)iter.next();
        }
        this.whatami = new int[this.bonds.length][];
        this.num = new int[this.bonds.length];
        for (int j = 0; j < this.bonds.length; ++j) {
            this.num[j] = 0;
            this.whatami[j] = new int[this.n];
            ArrayList al = this.bonds[j].getParamList();
            for (int i = 0; i < this.n; ++i) {
                boolean contains1 = al.contains(this.params[i]);
                if (contains1) {
                    this.whatami[j][i] = al.indexOf(this.params[i]);
                    int n = j;
                    this.num[n] = this.num[n] + 1;
                    continue;
                }
                this.whatami[j][i] = -1;
            }
        }
        System.out.println("Update now considers " + this.bonds.length + " bonds");
    }

    public String accepted() {
        String ac = "";
        for (int i = 0; i < this.accs.length; ++i) {
            ac = ac + i + ":" + this.accs[i] + " ";
        }
        return ac;
    }

    public void updateoutput() {
    }

    public void finish() {
    }

    public int[] acceptances() {
        return this.accs;
    }
}

