/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.ArgumentMaker;
import gov.lanl.yadas.Likelihood;
import gov.lanl.yadas.MCMCBond;
import gov.lanl.yadas.MCMCParameter;
import java.util.ArrayList;

public class MixtureBond
implements MCMCBond {
    public boolean pr = false;
    ArgumentMaker[][] am;
    Likelihood[] lik;
    MCMCParameter[][] params;
    ArrayList paramlist;
    int[][] translator;
    ArgumentMaker probarg;
    boolean value_computed = false;
    double current_value = 0.0;
    double new_value = 0.0;
    public String name = "Unnamed MixtureBond";
    double temp1 = 0.0;
    double temp2 = 0.0;
    double[][][] preargs;
    double[][][] args;
    double[][][] newargs;
    double[] preprob;
    double[] postprob;

    public MixtureBond(MCMCParameter[][] parameters, ArgumentMaker[][] am, Likelihood[] lik, ArgumentMaker probarg) {
        int i;
        this.probarg = probarg;
        this.am = am;
        this.lik = lik;
        this.params = parameters;
        this.paramlist = new ArrayList();
        this.translator = new int[this.params.length][];
        for (i = 0; i < this.params.length; ++i) {
            for (int j = 0; j < this.params[i].length; ++j) {
                if (this.paramlist.contains(this.params[i][j])) continue;
                this.paramlist.add(this.params[i][j]);
                this.params[i][j].addBond(this, this.paramlist.size() - 1);
            }
        }
        for (i = 0; i < this.params.length; ++i) {
            int j;
            this.translator[i] = new int[this.paramlist.size()];
            ArrayList<MCMCParameter> templist = new ArrayList<MCMCParameter>();
            for (j = 0; j < this.params[i].length; ++j) {
                templist.add(this.params[i][j]);
            }
            for (j = 0; j < this.paramlist.size(); ++j) {
                int ind;
                this.translator[i][j] = templist.contains(this.paramlist.get(j)) ? (ind = templist.indexOf(this.paramlist.get(j))) : -1;
            }
        }
    }

    void stage1() {
        this.temp2 = 0.0;
        this.temp1 = 0.0;
        this.prepareArgs();
        this.subtractOld();
    }

    void stage3() {
        this.addNew();
    }

    void prepareArgs() {
        int i;
        this.preargs = new double[this.params.length][][];
        this.args = new double[this.am.length][][];
        this.newargs = new double[this.am.length][][];
        for (i = 0; i < this.params.length; ++i) {
            this.preargs[i] = new double[this.params[i].length][];
        }
        for (i = 0; i < this.am.length; ++i) {
            this.args[i] = new double[this.am[i].length][];
            this.newargs[i] = new double[this.am[i].length][];
        }
        for (i = 0; i < this.params.length; ++i) {
            for (int j = 0; j < this.params[i].length; ++j) {
                this.preargs[i][j] = this.params[i][j].getValue();
            }
        }
    }

    void subtractOld() {
        for (int i = 0; i < this.args.length; ++i) {
            for (int j = 0; j < this.args[i].length; ++j) {
                this.args[i][j] = this.am[i][j].getArgument(this.preargs[i]);
            }
            this.preprob = this.probarg.getArgument(this.preargs[i]);
            if (!(this.preprob[i] > 0.0)) continue;
            this.temp1 += this.preprob[i] * Math.exp(this.lik[i].compute(this.args[i]));
        }
    }

    void addNew() {
        for (int i = 0; i < this.args.length; ++i) {
            for (int j = 0; j < this.args[i].length; ++j) {
                this.newargs[i][j] = this.am[i][j].getArgument(this.preargs[i]);
            }
            this.postprob = this.probarg.getArgument(this.preargs[i]);
            if (!(this.postprob[i] > 0.0)) continue;
            this.temp2 += this.postprob[i] * Math.exp(this.lik[i].compute(this.newargs[i]));
        }
    }

    public double compute(int whatami, double cand, int which) {
        this.stage1();
        for (int i = 0; i < this.args.length; ++i) {
            if (this.translator[i][whatami] < 0) continue;
            this.preargs[i][this.translator[i][whatami]][which] = cand;
        }
        this.stage3();
        return Math.log(this.temp2 / this.temp1);
    }

    public double compute(int whatami, double[] newpar) {
        double[][] twoway = new double[1][newpar.length];
        twoway[0] = newpar;
        return this.compute(new int[]{whatami}, twoway);
    }

    public double compute(int[] whatami, double[][] newpar) {
        int[] temp = new int[newpar.length];
        for (int i = 0; i < newpar.length; ++i) {
            temp[i] = i;
        }
        return this.compute(whatami, newpar, temp);
    }

    public double compute(int[] whatami, double[][] newpar, int[] which) {
        int j;
        int i;
        double temp0 = 0.0;
        double temp1 = 0.0;
        double[][][] preargs = new double[this.params.length][][];
        double[][][] args = new double[this.am.length][][];
        double[][][] newargs = new double[this.am.length][][];
        for (i = 0; i < this.params.length; ++i) {
            preargs[i] = new double[this.params[i].length][];
        }
        for (i = 0; i < this.am.length; ++i) {
            args[i] = new double[this.am[i].length][];
            newargs[i] = new double[this.am[i].length][];
        }
        for (i = 0; i < this.params.length; ++i) {
            for (j = 0; j < this.params[i].length; ++j) {
                preargs[i][j] = this.params[i][j].getValue();
            }
        }
        for (i = 0; i < args.length; ++i) {
            for (j = 0; j < args[i].length; ++j) {
                args[i][j] = this.am[i][j].getArgument(preargs[i]);
            }
            double[] preprob = this.probarg.getArgument(preargs[i]);
            if (preprob[i] > 0.0) {
                temp0 += preprob[i] * Math.exp(this.lik[i].compute(args[i]));
            }
            for (int k = 0; k < whatami.length; ++k) {
                if (this.translator[i][whatami[k]] < 0) continue;
                preargs[i][this.translator[i][whatami[k]]] = newpar[k];
            }
            for (j = 0; j < args[i].length; ++j) {
                newargs[i][j] = this.am[i][j].getArgument(preargs[i]);
            }
            double[] postprob = this.probarg.getArgument(preargs[i]);
            if (!(postprob[i] > 0.0)) continue;
            temp1 += postprob[i] * Math.exp(this.lik[i].compute(newargs[i]));
        }
        return Math.log(temp1 / temp0);
    }

    public void revise() {
    }

    public ArrayList getParamList() {
        return this.paramlist;
    }

    public void blank_value() {
        this.value_computed = false;
    }

    public double getCurrentValue() {
        return this.current_value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String nam) {
        this.name = nam;
    }
}

