/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.ArgumentMaker;
import gov.lanl.yadas.DataFrame;
import gov.lanl.yadas.Function;

public class LinearModelArgument
implements ArgumentMaker {
    DataFrame d;
    double[][] x;
    int[][] xcat;
    int n;
    int which;
    int[] which_xs;
    int[] which_cats;
    Function f;
    boolean nonidentity_link = true;
    int intercept = 0;

    public LinearModelArgument(DataFrame d, int intcp, int which_is_beta, int[] which_xs, int[] which_cats, Function f, boolean center) {
        this(d, intcp, which_is_beta, which_xs, which_cats, f);
        if (center) {
            this.centerX();
        }
    }

    public LinearModelArgument(DataFrame d, int intcp, int which_is_beta, int[] which_xs, int[] which_cats, Function f) {
        this.d = d;
        this.intercept = intcp;
        double[][] pre_x = d.getRealvars();
        this.xcat = d.getIntvars();
        this.n = d.length();
        this.which = which_is_beta;
        this.which_xs = which_xs;
        this.x = new double[which_xs.length][this.n];
        for (int i = 0; i < which_xs.length; ++i) {
            System.arraycopy(pre_x[which_xs[i]], 0, this.x[i], 0, this.n);
        }
        this.which_cats = which_cats;
        this.f = f;
    }

    public LinearModelArgument(DataFrame d, int intcp, int which_is_beta, int[] which_xs, int[] which_cats, boolean center) {
        this(d, intcp, which_is_beta, which_xs, which_cats);
        if (center) {
            this.centerX();
        }
    }

    public LinearModelArgument(DataFrame d, int intcp, int which_is_beta, int[] which_xs, int[] which_cats) {
        this(d, intcp, which_is_beta, which_xs, which_cats, new Function(){

            public double f(double[] args) {
                return args[0];
            }
        });
        this.nonidentity_link = false;
    }

    public LinearModelArgument(DataFrame d, int intcp, int which_is_beta, int[] which_xs, Function f) {
        this(d, intcp, which_is_beta, which_xs, new int[0], f);
    }

    public LinearModelArgument(DataFrame d, int intcp, int which_is_beta, int[] which_xs) {
        this(d, intcp, which_is_beta, which_xs, new Function(){

            public double f(double[] args) {
                return args[0];
            }
        });
        this.nonidentity_link = false;
    }

    public LinearModelArgument(DataFrame d, int intcp, int which_is_beta) {
        this(d, intcp, which_is_beta, LinearModelArgument.all(d.length()));
    }

    public LinearModelArgument(DataFrame d, int which_is_beta) {
        this(d, 0, which_is_beta);
    }

    void centerX() {
        System.out.println("Centering the continuous predictors in the linear model.");
        System.out.println("Their means were:");
        for (int j = 0; j < this.which_xs.length; ++j) {
            double tempmean = this.mean(this.x[j]);
            System.out.println("Variable " + j + "(" + this.which_xs[j] + ") : " + tempmean);
            int i = 0;
            while (i < this.x[j].length) {
                double[] dArray = this.x[j];
                int n = i++;
                dArray[n] = dArray[n] - tempmean;
            }
        }
    }

    public static int[] all(int m) {
        int[] out = new int[m];
        for (int i = 0; i < m; ++i) {
            out[i] = i;
        }
        return out;
    }

    public double[] getArgument(double[][] params) {
        int i;
        double[] beta = params[this.which];
        double[] out = new double[this.n];
        for (i = 0; i < this.n; ++i) {
            int j;
            if (this.intercept == 1) {
                int n = i;
                out[n] = out[n] + beta[0];
            }
            for (j = 0; j < this.which_xs.length; ++j) {
                int n = i;
                out[n] = out[n] + beta[j + this.intercept] * this.x[j][i];
            }
            for (j = 0; j < this.which_cats.length; ++j) {
                int n = i;
                out[n] = out[n] + params[this.which_cats[j]][this.xcat[j][i]];
            }
        }
        if (this.nonidentity_link) {
            for (i = 0; i < this.n; ++i) {
                out[i] = this.f.f(new double[]{out[i]});
            }
        }
        return out;
    }

    public double mean(double[] vec) {
        double out = 0.0;
        for (int i = 0; i < vec.length; ++i) {
            out += vec[i];
        }
        return out / (double)vec.length;
    }

    public double meansquare(double[] vec, double ctr) {
        double out = 0.0;
        for (int i = 0; i < vec.length; ++i) {
            out += (vec[i] - ctr) * (vec[i] - ctr);
        }
        return out / (double)vec.length;
    }

    public ScaledByPredictorsArgument argumentScaledByPredictors(ArgumentMaker argh) {
        return new ScaledByPredictorsArgument(argh);
    }

    public class ScaledByPredictorsArgument
    implements ArgumentMaker {
        ArgumentMaker argh;
        double[] covariateSDs;
        double[] outarg;

        public ScaledByPredictorsArgument(ArgumentMaker argh) {
            this.argh = argh;
            this.covariateSDs = new double[LinearModelArgument.this.which_xs.length];
            this.covariateSDs[0] = 1.0;
            for (int i = 0; i < LinearModelArgument.this.which_xs.length; ++i) {
                double[] temp = LinearModelArgument.this.x[i];
                this.covariateSDs[i] = Math.sqrt(LinearModelArgument.this.meansquare(temp, LinearModelArgument.this.mean(temp)));
            }
        }

        public double[] getArgument(double[][] params) {
            double[] innerarg = this.argh.getArgument(params);
            this.outarg = new double[innerarg.length];
            System.arraycopy(innerarg, 0, this.outarg, 0, innerarg.length);
            for (int i = 0; i < this.covariateSDs.length; ++i) {
                int n = i + LinearModelArgument.this.intercept;
                this.outarg[n] = this.outarg[n] / (this.covariateSDs[i] * 2.0);
            }
            return this.outarg;
        }
    }
}

