/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.ArgumentMaker;
import gov.lanl.yadas.BasicMCMCBond;
import gov.lanl.yadas.Beta;
import gov.lanl.yadas.ConstantArgument;
import gov.lanl.yadas.DataFrame;
import gov.lanl.yadas.FiniteMarkovChain;
import gov.lanl.yadas.FiniteUpdate;
import gov.lanl.yadas.Gamma;
import gov.lanl.yadas.Gaussian;
import gov.lanl.yadas.GroupArgument;
import gov.lanl.yadas.IdentityArgument;
import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.MCMCUpdate;
import gov.lanl.yadas.ScalarFrame;
import gov.lanl.yadas.TransitionMatrix;
import java.util.ArrayList;

public class HiddenMarkov {
    public static void main(String[] args) {
        int i;
        MCMCParameter p;
        MCMCParameter sigma;
        int B = 1000;
        String direc = "h:/projects/bickel/";
        String filename = "data.dat";
        String filename1 = "p.dat";
        String filename0 = "scalars.dat";
        try {
            if (args.length > 0) {
                B = Integer.parseInt(args[0]);
            }
            if (args.length > 1) {
                direc = args[1];
            }
            if (args.length > 2) {
                filename = args[2];
            }
            if (args.length > 3) {
                filename1 = args[3];
            }
            if (args.length > 4) {
                filename0 = args[4];
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Poor argument list!" + e);
        }
        DataFrame d = new DataFrame(direc + filename);
        DataFrame d1 = new DataFrame(direc + filename1);
        ScalarFrame d0 = new ScalarFrame(direc + filename0);
        MCMCParameter x = new MCMCParameter(d.r(0.0), d.r(1.0), direc + "x");
        MCMCParameter[] paramarray = new MCMCParameter[]{x, sigma = new MCMCParameter(d0.r("sigma"), d0.r(0.5), direc + "sigma"), p = new MCMCParameter(d1.r("p"), d1.r(0.2), direc + "p")};
        ArrayList<BasicMCMCBond> bondlist = new ArrayList<BasicMCMCBond>();
        BasicMCMCBond databond = new BasicMCMCBond(new MCMCParameter[]{x, sigma}, new ArgumentMaker[]{new ConstantArgument(d.r("y")), new IdentityArgument(0), new GroupArgument(1, d.i(0))}, new Gaussian());
        bondlist.add(databond);
        BasicMCMCBond chainbond = new BasicMCMCBond(new MCMCParameter[]{x, p}, new ArgumentMaker[]{new IdentityArgument(0), new TransitionMatrix(1, d1.length())}, new FiniteMarkovChain(d1.length()));
        bondlist.add(chainbond);
        BasicMCMCBond pprior = new BasicMCMCBond(new MCMCParameter[]{p}, new ArgumentMaker[]{new IdentityArgument(0), new ConstantArgument(d1.r("ap")), new ConstantArgument(d1.r("bp"))}, new Beta());
        bondlist.add(pprior);
        BasicMCMCBond sigmaprior = new BasicMCMCBond(new MCMCParameter[]{sigma}, new ArgumentMaker[]{new IdentityArgument(0), new ConstantArgument(d0.r("asigma")), new ConstantArgument(d0.r("bsigma"))}, new Gamma());
        bondlist.add(sigmaprior);
        MCMCUpdate[] updatearray = new MCMCUpdate[]{sigma, p, new FiniteUpdate(x, d.i(d1.length()))};
        for (int b = 0; b < B; ++b) {
            if ((double)b / 100.0 - (double)(b / 100) == 0.0) {
                System.out.println(b);
            }
            for (i = 0; i < updatearray.length; ++i) {
                updatearray[i].update();
            }
            for (i = 0; i < paramarray.length; ++i) {
                if ((double)b / 1.0 - (double)(b / 1) != 0.0) continue;
                paramarray[i].output();
            }
        }
        for (int iii = 0; iii < updatearray.length; ++iii) {
            String acc = updatearray[iii].accepted();
            System.out.println("Update " + iii + ": " + acc);
        }
        for (i = 0; i < paramarray.length; ++i) {
            paramarray[i].finish();
        }
    }
}

