/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.ArgumentMaker;
import gov.lanl.yadas.BasicMCMCBond;
import gov.lanl.yadas.Beta;
import gov.lanl.yadas.Binomial;
import gov.lanl.yadas.ConstantArgument;
import gov.lanl.yadas.DataFrame;
import gov.lanl.yadas.Function;
import gov.lanl.yadas.FunctionalArgument;
import gov.lanl.yadas.Gamma;
import gov.lanl.yadas.IdentityArgument;
import gov.lanl.yadas.LogitMCMCParameter;
import gov.lanl.yadas.MCMCParameter;
import gov.lanl.yadas.MCMCUpdate;
import gov.lanl.yadas.ReliableSystem;
import java.util.ArrayList;

public class GenericSeriesSystem {
    public static void main(String[] args) {
        MCMCParameter nu;
        MCMCParameter ptilde;
        int B = 1000;
        String direc = "h:/projects/systemreliability/";
        String filename = "components.dat";
        String shortfilename = "leaves.dat";
        String priorfilename = "ptilde.dat";
        String nufilename = "nu.dat";
        try {
            if (args.length > 0) {
                B = Integer.parseInt(args[0]);
            }
            if (args.length > 1) {
                direc = args[1];
            }
            if (args.length > 2) {
                filename = args[2];
            }
            if (args.length > 3) {
                shortfilename = args[3];
            }
            if (args.length > 4) {
                priorfilename = args[4];
            }
            if (args.length > 5) {
                nufilename = args[5];
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Poor argument list!" + e);
        }
        DataFrame d = new DataFrame(direc + filename);
        DataFrame leafd = new DataFrame(direc + shortfilename);
        DataFrame priord = new DataFrame(direc + priorfilename);
        DataFrame nud = new DataFrame(direc + nufilename);
        MCMCParameter[] mCMCParameterArray = new MCMCParameter[3];
        LogitMCMCParameter p = new LogitMCMCParameter(leafd.r("p"), leafd.r("pmss"), direc + "p");
        mCMCParameterArray[0] = p;
        mCMCParameterArray[1] = ptilde = new MCMCParameter(priord.r("ptilde"), priord.r(0.0), direc + "ptilde");
        mCMCParameterArray[2] = nu = new MCMCParameter(nud.r("nu"), nud.r("numss"), direc + "nu");
        MCMCParameter[] paramarray = mCMCParameterArray;
        ReliableSystem system = new ReliableSystem(d.length());
        system.SeriesIntegratorsFromFile(d.i("parents"));
        ArrayList<BasicMCMCBond> bondlist = new ArrayList<BasicMCMCBond>();
        BasicMCMCBond binomialdata = new BasicMCMCBond(new MCMCParameter[]{p}, new ArgumentMaker[]{new ConstantArgument(d.r("x")), new ConstantArgument(d.r("n")), system.fillProbs(d.i("pexpand"), d.i("order"))}, new Binomial());
        bondlist.add(binomialdata);
        BasicMCMCBond p_prior = new BasicMCMCBond(new MCMCParameter[]{p, ptilde, nu}, new ArgumentMaker[]{system.fillProbs(d.i("pexpand"), d.i("order")), new FunctionalArgument(d.length(), 3, new int[]{0, 1, 2}, new int[][]{d.i(0), d.i("priorexpand"), d.i("nuexpand")}, new Function(){

            public double f(double[] args) {
                return args[1] * args[2] + 1.0;
            }
        }), new FunctionalArgument(d.length(), 3, new int[]{0, 1, 2}, new int[][]{d.i(0), d.i("priorexpand"), d.i("nuexpand")}, new Function(){

            public double f(double[] args) {
                return (1.0 - args[1]) * args[2] + 1.0;
            }
        })}, new Beta());
        bondlist.add(p_prior);
        BasicMCMCBond nu_prior = new BasicMCMCBond(new MCMCParameter[]{nu}, new ArgumentMaker[]{new IdentityArgument(0), new ConstantArgument(nud.r("anu")), new ConstantArgument(nud.r("bnu"))}, new Gamma());
        bondlist.add(nu_prior);
        p.nf.setMaximumFractionDigits(6);
        binomialdata.setName("binomialdata");
        p_prior.setName("p_prior");
        nu_prior.setName("nu_prior");
        MCMCUpdate[] updatearray = new MCMCUpdate[]{p, nu};
        for (int b = 0; b < B; ++b) {
            int i;
            if ((double)b / 20.0 - (double)(b / 20) == 0.0) {
                System.out.println(b);
            }
            for (i = 0; i < updatearray.length; ++i) {
                updatearray[i].update();
            }
            for (i = 0; i < paramarray.length; ++i) {
                paramarray[i].output();
            }
        }
        for (int i = 0; i < paramarray.length; ++i) {
            paramarray[i].finish();
        }
    }
}

