/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ChainedTransformer;
import org.apache.commons.collections15.functors.CloneTransformer;
import org.apache.commons.collections15.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLayout<V, E>
implements Layout<V, E> {
    private Set<V> dontmove = new HashSet<V>();
    protected Dimension size;
    protected Graph<V, E> graph;
    protected boolean initialized;
    protected Map<V, Point2D> locations = LazyMap.decorate(new HashMap(), new Transformer<V, Point2D>(){

        @Override
        public Point2D transform(V arg0) {
            return new Point2D.Double();
        }
    });

    protected AbstractLayout(Graph<V, E> graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph must be non-null");
        }
        this.graph = graph;
    }

    protected AbstractLayout(Graph<V, E> graph, Transformer<V, Point2D> initializer) {
        this.graph = graph;
        Transformer chain = ChainedTransformer.getInstance(initializer, CloneTransformer.getInstance());
        this.locations = LazyMap.decorate(new HashMap(), chain);
        this.initialized = true;
    }

    protected AbstractLayout(Graph<V, E> graph, Dimension size) {
        this.graph = graph;
        this.size = size;
    }

    protected AbstractLayout(Graph<V, E> graph, Transformer<V, Point2D> initializer, Dimension size) {
        this.graph = graph;
        Transformer chain = ChainedTransformer.getInstance(initializer, CloneTransformer.getInstance());
        this.locations = LazyMap.decorate(new HashMap(), chain);
        this.size = size;
    }

    @Override
    public void setGraph(Graph<V, E> graph) {
        this.graph = graph;
        if (this.size != null && graph != null) {
            this.initialize();
        }
    }

    @Override
    public void setSize(Dimension size) {
        if (size != null && this.graph != null) {
            Dimension oldSize = this.size;
            this.size = size;
            this.initialize();
            if (oldSize != null) {
                this.adjustLocations(oldSize, size);
            }
        }
    }

    private void adjustLocations(Dimension oldSize, Dimension size) {
        int xOffset = (size.width - oldSize.width) / 2;
        int yOffset = (size.height - oldSize.height) / 2;
        while (true) {
            try {
                for (Object v : this.getGraph().getVertices()) {
                    this.offsetVertex(v, xOffset, yOffset);
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
    }

    @Override
    public boolean isLocked(V v) {
        return this.dontmove.contains(v);
    }

    @Override
    public void setInitializer(Transformer<V, Point2D> initializer) {
        if (this.equals(initializer)) {
            throw new IllegalArgumentException("Layout cannot be initialized with itself");
        }
        Transformer chain = ChainedTransformer.getInstance(initializer, CloneTransformer.getInstance());
        this.locations = LazyMap.decorate(new HashMap(), chain);
        this.initialized = true;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    private Point2D getCoordinates(V v) {
        return this.locations.get(v);
    }

    @Override
    public Point2D transform(V v) {
        return this.getCoordinates(v);
    }

    public double getX(V v) {
        assert (this.getCoordinates(v) != null) : "Cannot getX for an unmapped vertex " + v;
        return this.getCoordinates(v).getX();
    }

    public double getY(V v) {
        assert (this.getCoordinates(v) != null) : "Cannot getY for an unmapped vertex " + v;
        return this.getCoordinates(v).getY();
    }

    protected void offsetVertex(V v, double xOffset, double yOffset) {
        Point2D c = this.getCoordinates(v);
        c.setLocation(c.getX() + xOffset, c.getY() + yOffset);
        this.setLocation(v, c);
    }

    @Override
    public Graph<V, E> getGraph() {
        return this.graph;
    }

    public void setLocation(V picked, double x, double y) {
        Point2D coord = this.getCoordinates(picked);
        coord.setLocation(x, y);
    }

    @Override
    public void setLocation(V picked, Point2D p) {
        Point2D coord = this.getCoordinates(picked);
        coord.setLocation(p);
    }

    @Override
    public void lock(V v, boolean state) {
        if (state) {
            this.dontmove.add(v);
        } else {
            this.dontmove.remove(v);
        }
    }

    public void lock(boolean lock) {
        for (Object v : this.graph.getVertices()) {
            this.lock(v, lock);
        }
    }
}

