/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.linalg;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Matrix2DMatrix2DFunction;

class Smp {
    protected FJTaskRunnerGroup taskGroup;
    protected int maxThreads;

    protected Smp(int n) {
        this.maxThreads = n = Math.max(1, n);
        this.taskGroup = n > 1 ? new FJTaskRunnerGroup(n) : null;
    }

    public void finalize() {
        if (this.taskGroup != null) {
            this.taskGroup.interruptAll();
        }
    }

    protected void run(final DoubleMatrix2D[] doubleMatrix2DArray, final DoubleMatrix2D[] doubleMatrix2DArray2, final double[] dArray, final Matrix2DMatrix2DFunction matrix2DMatrix2DFunction) {
        final FJTask[] fJTaskArray = new FJTask[doubleMatrix2DArray.length];
        for (int i = 0; i < doubleMatrix2DArray.length; ++i) {
            final int n = i;
            fJTaskArray[i] = new FJTask(){

                public void run() {
                    double d = matrix2DMatrix2DFunction.apply(doubleMatrix2DArray[n], doubleMatrix2DArray2 != null ? doubleMatrix2DArray2[n] : null);
                    if (dArray != null) {
                        dArray[n] = d;
                    }
                }
            };
        }
        try {
            this.taskGroup.invoke(new FJTask(){

                public void run() {
                    2.coInvoke(fJTaskArray);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected DoubleMatrix2D[] splitBlockedNN(DoubleMatrix2D doubleMatrix2D, int n, long l) {
        int n2 = (int)Math.min(l / (long)n, (long)this.maxThreads);
        boolean bl = doubleMatrix2D.columns() < n2;
        int n3 = bl ? doubleMatrix2D.rows() : doubleMatrix2D.columns();
        n2 = Math.min(n3, n2);
        if (n2 < 2) {
            return null;
        }
        int n4 = n3 / n2;
        DoubleMatrix2D[] doubleMatrix2DArray = new DoubleMatrix2D[n2];
        for (int i = 0; i < n2; ++i) {
            int n5 = i * n4;
            if (i == n2 - 1) {
                n4 = n3 - n4 * i;
            }
            doubleMatrix2DArray[i] = !bl ? doubleMatrix2D.viewPart(0, n5, doubleMatrix2D.rows(), n4) : doubleMatrix2D.viewPart(n5, 0, n4, doubleMatrix2D.columns());
        }
        return doubleMatrix2DArray;
    }

    protected DoubleMatrix2D[][] splitBlockedNN(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, int n, long l) {
        DoubleMatrix2D[] doubleMatrix2DArray = this.splitBlockedNN(doubleMatrix2D, n, l);
        if (doubleMatrix2DArray == null) {
            return null;
        }
        DoubleMatrix2D[] doubleMatrix2DArray2 = this.splitBlockedNN(doubleMatrix2D2, n, l);
        if (doubleMatrix2DArray2 == null) {
            return null;
        }
        DoubleMatrix2D[][] doubleMatrix2DArray3 = new DoubleMatrix2D[][]{doubleMatrix2DArray, doubleMatrix2DArray2};
        return doubleMatrix2DArray3;
    }

    protected DoubleMatrix2D[] splitStridedNN(DoubleMatrix2D doubleMatrix2D, int n, long l) {
        int n2 = (int)Math.min(l / (long)n, (long)this.maxThreads);
        boolean bl = doubleMatrix2D.columns() < n2;
        int n3 = bl ? doubleMatrix2D.rows() : doubleMatrix2D.columns();
        n2 = Math.min(n3, n2);
        if (n2 < 2) {
            return null;
        }
        int n4 = n3 / n2;
        DoubleMatrix2D[] doubleMatrix2DArray = new DoubleMatrix2D[n2];
        for (int i = 0; i < n2; ++i) {
            int n5 = i * n4;
            if (i == n2 - 1) {
                n4 = n3 - n4 * i;
            }
            doubleMatrix2DArray[i] = !bl ? doubleMatrix2D.viewPart(0, i, doubleMatrix2D.rows(), doubleMatrix2D.columns() - i).viewStrides(1, n2) : doubleMatrix2D.viewPart(i, 0, doubleMatrix2D.rows() - i, doubleMatrix2D.columns()).viewStrides(n2, 1);
        }
        return doubleMatrix2DArray;
    }

    public void stats() {
        if (this.taskGroup != null) {
            this.taskGroup.stats();
        }
    }
}

