% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geelm-control.R
\name{geelm.control}
\alias{geelm.control}
\title{Control estimation of GEE models}
\usage{
geelm.control(
  init.beta = NULL,
  init.phi = 1,
  tol = 1e-05,
  maxit = 20,
  scale.fix = FALSE,
  useP = TRUE,
  std.err = "san.se"
)
}
\arguments{
\item{init.beta}{
an optional vector with the initial values of beta.  If not specified, then the intercept will be set to \code{InvLink(mean(response))}.  \code{init.beta} must be specified if not using an intercept.
}

\item{init.phi}{
an optional initial overdispersion parameter.  If not supplied, initialized to 1.
}

\item{tol}{Tolerance for asserting convergence.}

\item{maxit}{integer giving the maximal number of Fisher Scoring
iteration.}

\item{scale.fix}{logical indicating if the scale should be fixed.}

\item{useP}{If set to \code{FALSE}, do not use the n-p correction for
dispersion and correlation estimates. This can be
useful when the number of observations is small, as subtracting p may yield
correlations greater than 1.}

\item{std.err}{Character string specifying which standard error
estimation method should be used. Supported options are
\code{san.se} (sandwich SE) and \code{naive}.}
}
\value{
A list of values used for controlling model fitting.
}
\description{
Settings for controlling technical details of GEE fitting via geelm.
}
