% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmod_man.R
\name{cmod_man}
\alias{cmod_man}
\title{Manual covariance models for geostatistical data.}
\usage{
cmod_man(v, evar = 0)
}
\arguments{
\item{v}{The covariance matrix of the observed data,
including any errors.  The matrix should be square,
symmetric, and positive definite, though that latter
two conditions are not checked.}

\item{evar}{The variance of the errors.  Must be
non-negative number.  The default is 0.}
}
\value{
Returns a \code{cmodMan} object.
}
\description{
\code{cmod_man} manually creates a covariance model
object (\code{cmodMan}) for geostatistical data.
}
\details{
Note that \code{v} includes the error variance, i.e.,
\code{v = vz + ve}, where \code{vz} is the covariance
matrix of the filtered (measurement-error-free) process,
and the variance matrix of the errors is \code{ve =
diag(evar/weights)}, where the weights come from the
\code{geolm} object the covariance object is associated
with.
}
\examples{
coords = matrix(runif(6), ncol = 2)
d = as.matrix(dist(coords))
cmod_man(v = exp(-d), evar = 1) 
}
\author{
Joshua French
}
