% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\name{stack_cube}
\alias{stack_cube}
\title{Create a data cube from a set of images with the same spatial extent and spatial reference system}
\usage{
stack_cube(
  x,
  datetime_values,
  bands = NULL,
  band_names = NULL,
  chunking = c(1, 256, 256),
  dx = NULL,
  dy = NULL
)
}
\arguments{
\item{x}{character vector where items point to image files}

\item{datetime_values}{vector of type character, Date, or POSIXct with recording date of images}

\item{bands}{optional character vector defining the band or spectral band of each item in x, if files relate to different spectral bands or variables}

\item{band_names}{name of bands, only used if bands is NULL, i.e., if all files contain the same spectral band(s) / variable(s)}

\item{chunking}{vector of length 3 defining the size of data cube chunks in the order time, y, x.}

\item{dx}{optional target pixel size in x direction, by default (NULL) the original or highest resolution of images is used}

\item{dy}{optional target pixel size in y direction, by default (NULL) the original or highest resolution of images is used}
}
\value{
A proxy data cube object
}
\description{
Create a spatiotemporal data cube directly from images with identical spatial extent and spatial reference system, similar
to a raster stack with an additional dimension supporting both, time and multiple bands / variables.
}
\details{
This function creates a four-dimensional (space, time, bands / variables) raster data cube from a 
set of provided files without the need to create an image collection before. This is  possible if all images
have the same spatial extent and spatial reference system and can be used for two different file organizations:

1. If all image files share the same bands / variables, the \code{bands} argument can be ignored (default NULL) can 
names of the bands can be specified using the \code{band_names} argument.

2. If image files represent different band / variable  (e.g. individual files for red, green, and blue channels), the \code{bands}
argument must be used to define the corresponding band / variable. Notice that in this case all files are expected to 
represent exactly one variable / band at one point in datetime. It is not possible to combine files with different
numbers of variables / bands. If image files for different bands have different pixel sizes, the smallest size is used
by default.

Notice that to avoid opening all image files in advance,no automatic check whether all images share the 
spatial extent and spatial reference system is performed.
}
\note{
This function returns a proxy object, i.e., it will not start any computations besides deriving the shape of the result.
}
\examples{
# toy example, repeating the same image as a daily time series
L8_file_nir <- 
system.file("L8NY18/LC08_L1TP_014032_20181122_20181129_01_T1/LC08_L1TP_014032_20181122_B5.TIF",
            package = "gdalcubes")
files = rep(L8_file_nir, 10)
datetime = as.Date("2018-11-22") + 1:10
stack_cube(files, datetime, band_names = "B05") 

# using a second band from different files
L8_file_red <- 
system.file("L8NY18/LC08_L1TP_014032_20181122_20181129_01_T1/LC08_L1TP_014032_20181122_B4.TIF",
            package = "gdalcubes")
files = rep(c(L8_file_nir, L8_file_red), each = 10)
datetime = rep(as.Date("2018-11-22") + 1:10, 2)
bands = rep(c("B5","B4"), each = 10)
stack_cube(files, datetime, bands = bands)         

}
