% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streaming.R
\name{read_chunk_as_array}
\alias{read_chunk_as_array}
\title{Read chunk data of a data cube from stdin or a file}
\usage{
read_chunk_as_array(with.dimnames = TRUE)
}
\arguments{
\item{with.dimnames}{if TRUE, the resulting array will contain dimnames with coordinates, datetime, and band names}
}
\value{
four-dimensional array
}
\description{
This function can be used within function passed to \code{\link{chunk_apply}} in order to read a data cube chunk as a four-dimensional R array.
It works only for R processes, which have been started from the gdalcubes C++ library. 
The resulting array has dimensions band, time, y, x (in this order).
}
\note{
Call this function ONLY from a function passed to \code{\link{chunk_apply}}.

This function only works in R sessions started from gdalcubes streaming.
}
\examples{
\donttest{
# create image collection from example Landsat data only 
# if not already done in other examples
if (!file.exists(file.path(tempdir(), "L8.db"))) {
  L8_files <- list.files(system.file("L8NY18", package = "gdalcubes"),
                         ".TIF", recursive = TRUE, full.names = TRUE)
  create_image_collection(L8_files, "L8_L1TP", file.path(tempdir(), "L8.db")) 
}

L8.col = image_collection(file.path(tempdir(), "L8.db"))
v = cube_view(extent=list(left=388941.2, right=766552.4,
                          bottom=4345299, top=4744931, t0="2018-01", t1="2018-12"),
                          srs="EPSG:32618", nx = 497, ny=526, dt="P1M")
L8.cube = raster_cube(L8.col, v)
L8.cube = select_bands(L8.cube, c("B04", "B05"))
f <- function() {
  x <- read_chunk_as_array()
  out <- reduce_time(x, function(x) {
    cor(x[1,], x[2,], use="na.or.complete", method = "kendall")
  }) 
  write_chunk_from_array(out)
}
L8.cor = chunk_apply(L8.cube, f)
plot(L8.cor, zlim=c(0,1), key.pos=1)
}
}
