\name{body}
\alias{body}
\docType{data}
\title{Exploring Relationships in Body Dimensions}
\description{


This dataset contains 21 body dimension measurements as well as age, 
weight, height, and gender on 507 individuals. The 247 men and 260 
women were primarily individuals in their twenties and thirties, with a 
scattering of older men and women, all exercising several hours a week.

Measurements were initially taken by Grete 
Heinz and Louis J. Peterson - at San Jose State University and at the 
U.S. Naval Postgraduate School in Monterey, California. Later, 
measurements were taken at dozens of California health and fitness 
clubs by technicians under the supervision of one of these authors.


}
\format{This data frame contains the following columns:
 \describe{
 \item{Biacrom:}{Biacromial diameter (cm)}
 \item{Biiliac:}{Biiliac diameter, or "pelvic breadth" (cm)}
 \item{Bitro:}{Bitrochanteric diameter (cm)}
 \item{ChestDp:}{Chest depth between spine and sternum at nipple level, 
            mid-expiration (cm)}
 \item{ChestD:}{Chest diameter at nipple level, mid-expiration (cm)}
 \item{ElbowD:}{Elbow diameter, sum of two elbows (cm)}
 \item{WristD:}{Wrist diameter, sum of two wrists (cm)}
 \item{KneeD:}{Knee diameter, sum of two knees (cm)}
 \item{AnkleD:}{Ankle diameter, sum of two ankles (cm)}
 \item{ShoulderG:}{Shoulder girth over deltoid muscles (cm)}
 \item{ChestG:}{Chest girth, nipple line in males and just above breast 
            tissue in females, mid-expiration (cm)}
 \item{WaistG:}{Waist girth, narrowest part of torso below the rib cage, 
            average of contracted and relaxed position (cm)}
 \item{AbdG:}{Navel (or "Abdominal") girth at umbilicus and iliac crest, 
            iliac crest as a landmark (cm)}
 \item{HipG:}{Hip girth at level of bitrochanteric diameter (cm)}
 \item{ThighG:}{Thigh girth below gluteal fold, average of right and left 
            girths (cm)}
 \item{BicepG:}{Bicep girth, flexed, average of right and left girths (cm)}
 \item{ForearmG:}{Forearm girth, extended, palm up, average of right and 
            left girths (cm)}
 \item{KneeG:}{Knee girth over patella, slightly flexed position, average 
            of right and left girths (cm)}
 \item{CalfG:}{Calf maximum girth, average of right and left girths (cm)}
 \item{AnkleG:}{Ankle minimum girth, average of right and left girths
 (cm)}
 \item{WristG:}{Wrist minimum girth, average of right and left girths (cm)}

 \item{Age:}{in years}
 \item{Weight:}{in kg}
 \item{Height:}{in cm}
 \item{Gender:}{1 - male, 0 - female}
 
}}
\usage{data(body)}



\source{
Heinz, G., Peterson, L.J., Johnson, R.W. and Kerk, C.J. (2003),
``Exploring Relationships in Body Dimensions'',
\emph{Journal of Statistics Education }, 11.

}
\references{
The data file is taken from 
\url{http://www.amstat.org/publications/jse/datasets/body.dat}
This information file is based on
\url{http://www.amstat.org/publications/jse/datasets/body.txt}
}
\keyword{datasets}
