% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment-generics.R, R/Segment-methods.R
\docType{methods}
\name{Include}
\alias{Include}
\alias{Include,ANY-method}
\title{Include}
\usage{
Include(object, ..., scope)

\S4method{Include}{ANY}(object, ..., scope)
}
\arguments{
\item{object}{A segment condition or sequence filter to include.}

\item{...}{Additional segment conditions to include.}

\item{scope}{Optional scope, \code{"users"} or \code{"sessions"} (default).}
}
\value{
A \code{.gaSegmentFilter} object with its negate slot set to
\code{FALSE}.
}
\description{
Set the negation flag of a segment filter to \code{FALSE}.
}
\section{Methods (by class)}{
\itemize{
\item \code{ANY}: Define an include segment filter using the supplied
expression.
}}

\examples{
return_shoppers <- Include(
  Expr(~transactions > 1, metricScope = "perUser"),
  scope = "users"
)

}
\seealso{
Other dynamic segment functions: \code{\link{DynSegment}},
  \code{\link{Exclude}}, \code{\link{IsNegated}},
  \code{\link{PerHit}}, \code{\link{PerProduct}},
  \code{\link{PerSession}}, \code{\link{PerUser}},
  \code{\link{ScopeLevel}},
  \code{\link{SegmentConditionFilter}},
  \code{\link{Segments}}, \code{\link{Segment}}
}
\concept{dynamic segment functions}
