% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if-null.R
\name{if_null}
\alias{if_null}
\alias{\%||\%}
\alias{\%|||\%}
\alias{\%len\%}
\title{Default value for \code{NULL} or no length}
\usage{
x \%||\% y

x \%|||\% y

x \%len\% y
}
\arguments{
\item{x, y}{If \code{x} is \code{NULL} returns \code{y}; otherwise \code{x}}
}
\value{
\code{x} if it is not \code{NULL} or has length, depending on check
}
\description{
Replace if \code{NULL} or not length
}
\details{
A mostly copy of \code{rlang}'s \verb{\%||\%} except does not use \code{rlang::is_null()},
which, currently, calls the same primitive \link[base:NULL]{base::is.null} function.
}
\examples{
# replace NULL
NULL \%||\% 1L
2L   \%||\% 1L

# replace empty
""       \%|||\% 1L
NA       \%|||\% 1L
double() \%|||\% 1L
NULL     \%|||\% 1L

# replace no length
logical() \%len\% TRUE
}
