% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth.R
\name{pervertexdata.smoothnn.compute.fwhm}
\alias{pervertexdata.smoothnn.compute.fwhm}
\title{Compute expected FWHM from given number of neighborhood smoothing iterations.}
\usage{
pervertexdata.smoothnn.compute.fwhm(surface, niters, is_template)
}
\arguments{
\item{surface}{an \code{fs.surface} instance}

\item{niters}{positive integer, the nn iteration count}

\item{is_template}{logical, whether the surface belongs to a template subject}
}
\value{
double, the expected FWHM
}
\description{
Compute expected FWHM from given number of neighborhood smoothing iterations.
}
\note{
This function has been adapted from FreeSurfer and it is subject to the FreeSurfer software license.
}
\examples{
\dontrun{
spherical_surface = subject.surface(fsaverage.path(), "fsaverage3", surface="sphere", hemi="lh");
fsbrain:::pervertexdata.smoothnn.compute.fwhm(spherical_surface, 5L);
}


}
\keyword{internal}
