% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brain_igraph.R
\name{fs.surface.to.igraph}
\alias{fs.surface.to.igraph}
\title{Create igraph undirected graph from a brain surface mesh.}
\usage{
fs.surface.to.igraph(surface)
}
\arguments{
\item{surface}{an fs.surface instance as returned by \code{subject.surface}, an existing igraph (which will be returned as-is) or a string which is interpreted as a path to a surface file.}
}
\value{
igraph::graph instance
}
\description{
Create igraph undirected graph from a brain surface mesh.
}
\examples{
\dontrun{
  # Find the one-ring neighbors of vertex 15 on the fsaverage left hemi:
  sf = subject.surface(fsaverage.path(T), "fsaverage", "white", "lh");
  g = fs.surface.to.igraph(sf);
  igraph::neighborhood(g, order = 1, nodes = 15);
}

}
