% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{annot.outline.border.vertices}
\alias{annot.outline.border.vertices}
\title{Compute the border vertices for each region in an annot.}
\usage{
annot.outline.border.vertices(
  annotdata,
  surface_mesh,
  silent = TRUE,
  expand_inwards = 0L,
  limit_to_regions = NULL
)
}
\arguments{
\item{annotdata}{an annotation, as returned by functions like \code{\link[fsbrain]{subject.annot}}. If a character string, interpreted as a path to a file containing such data, and loaded with \code{freesurferformats::read.fs.annot}}

\item{surface_mesh}{brain surface mesh, as returned by functions like \code{\link[fsbrain]{subject.surface}} or \code{\link[freesurferformats]{read.fs.surface}}. If a character string, interpreted as a path to a file containing such data, and loaded with \code{freesurferformats::read.fs.surface}}

\item{silent}{logical, whether to suppress status messages.}

\item{expand_inwards}{integer, additional thickness of the borders. Increases computation time, defaults to 0L.}

\item{limit_to_regions}{vector of character strings or NULL, a list of regions for which to draw the outline (see \code{\link[fsbrain]{get.atlas.region.names}}). If NULL, all regions will be used. If (and only if) this parameter is used, the 'outline_color' parameter can be a vector of color strings, one color per region.}
}
\value{
named list, the keys are the region names and the values are vectors of integers encoding vertex indices.
}
\description{
Compute the border vertices for each region in an annot.
}
